/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.annotations.asm;

import com.atlassian.plugins.codegen.annotations.BambooPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.BitbucketPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.ConfluencePluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.CrowdPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.FeCruPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.RefAppPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleCreatorRegistry;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ModuleCreatorAnnotationParser
extends AbstractAnnotationParser {
    public static final String MODULE_PACKAGE = "com.atlassian.plugins.codegen.modules";
    private static final Map<String, String> annotationProductMap = ImmutableMap.builder().put((Object)BambooPluginModuleCreator.class.getName(), (Object)"bamboo").put((Object)BitbucketPluginModuleCreator.class.getName(), (Object)"bitbucket").put((Object)ConfluencePluginModuleCreator.class.getName(), (Object)"confluence").put((Object)CrowdPluginModuleCreator.class.getName(), (Object)"crowd").put((Object)FeCruPluginModuleCreator.class.getName(), (Object)"fecru").put((Object)JiraPluginModuleCreator.class.getName(), (Object)"jira").put((Object)RefAppPluginModuleCreator.class.getName(), (Object)"refapp").build();
    private final PluginModuleCreatorRegistry pluginModuleCreatorRegistry;

    public ModuleCreatorAnnotationParser(PluginModuleCreatorRegistry pluginModuleCreatorRegistry) {
        this.pluginModuleCreatorRegistry = pluginModuleCreatorRegistry;
    }

    public void parse() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.parse(MODULE_PACKAGE, new ModuleClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void parse(String basePackage) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.parse(basePackage, new ModuleClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public class ModuleClassVisitor
    extends ClassVisitor {
        private String visitedClassname;
        private boolean isModuleCreator;

        public ModuleClassVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitedClassname = AbstractAnnotationParser.normalize(name);
            String iface = PluginModuleCreator.class.getName().replace('.', '/');
            this.isModuleCreator = ArrayUtils.contains((Object[])interfaces, (Object)iface);
            if (!this.isModuleCreator) {
                this.isModuleCreator = this.superHasInterface(superName, iface);
            }
        }

        private boolean superHasInterface(String superName, String interfaceName) {
            boolean hasInterface = false;
            if (AbstractAnnotationParser.normalize(superName).equals("java.lang.Object")) {
                return false;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = superName.replace('.', '/');
            try (InputStream is = classLoader.getResourceAsStream(path + ".class");){
                ClassReader classReader;
                if (is != null && !(hasInterface = ArrayUtils.contains((Object[])(classReader = new ClassReader(is)).getInterfaces(), (Object)interfaceName))) {
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            String normalizedName = AbstractAnnotationParser.normalize(annotationName);
            if (this.isModuleCreator && annotationProductMap.containsKey(normalizedName)) {
                return new ProductCreatorAnnotationVisitor(normalizedName);
            }
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }

        private class ProductCreatorAnnotationVisitor
        extends AnnotationVisitor {
            private String annotationName;

            private ProductCreatorAnnotationVisitor(String annotationName) {
                super(327680);
                this.annotationName = annotationName;
            }

            public void visitEnd() {
                super.visitEnd();
                String productId = (String)annotationProductMap.get(this.annotationName);
                if (StringUtils.isNotBlank((CharSequence)productId)) {
                    try {
                        PluginModuleCreator creator = (PluginModuleCreator)Class.forName(ModuleClassVisitor.this.visitedClassname).newInstance();
                        ModuleCreatorAnnotationParser.this.pluginModuleCreatorRegistry.registerModuleCreator(productId, creator);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

