/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.host.plugin.ApplicationMetaDataModuleDescriptor;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.application.host.util.Arguments;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPluginApplicationMetaDataManager
implements PluginApplicationMetaDataManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginApplicationMetaDataManager.class);
    private final PluginAccessor accessor;

    public DefaultPluginApplicationMetaDataManager(PluginAccessor accessor) {
        this.accessor = Arguments.checkArgumentNotNull(accessor, "accessor");
    }

    @Override
    public Iterable<PluginApplicationMetaData> getApplications() {
        List moduleDescriptors = this.accessor.getEnabledModuleDescriptorsByClass(ApplicationMetaDataModuleDescriptor.class);
        ImmutableList.Builder uniqueModuleDescriptors = ImmutableList.builder();
        HashSet keys = Sets.newHashSet();
        for (ApplicationMetaDataModuleDescriptor moduleDescriptor : moduleDescriptors) {
            PluginApplicationMetaData module = (PluginApplicationMetaData)moduleDescriptor.getModule();
            if (keys.add(module.getKey())) {
                uniqueModuleDescriptors.add((Object)module);
                continue;
            }
            log.debug(String.format("Application descriptor with id '%s' has a duplicate.", module.getKey()));
        }
        return uniqueModuleDescriptors.build();
    }

    @Override
    public Option<PluginApplicationMetaData> getApplication(final ApplicationKey key) {
        Arguments.checkArgumentNotNull(key, "key");
        return Iterables.findFirst(this.getApplications(), (Predicate)new com.google.common.base.Predicate<PluginApplicationMetaData>(){

            public boolean apply(PluginApplicationMetaData input) {
                return input.getKey().equals((Object)key);
            }
        });
    }
}

