/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive;

import com.atlassian.beehive.ClusterLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

class SingleNodeLock
implements ClusterLock {
    private final ReentrantLock lock = new ReentrantLock();

    SingleNodeLock() {
    }

    public void lockInterruptibly() throws InterruptedException {
        this.assertNotReentrant();
        this.lock.lockInterruptibly();
    }

    public boolean tryLock() {
        this.assertNotReentrant();
        return this.lock.tryLock();
    }

    public boolean tryLock(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        this.assertNotReentrant();
        return this.lock.tryLock(timeout, unit);
    }

    public void lock() {
        this.assertNotReentrant();
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Nonnull
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private void assertNotReentrant() {
        if (this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Attempt to re-enter this lock.");
        }
    }
}

