/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.rescoped")
public class PullRequestRescopedEvent
extends PullRequestEvent {
    private final RescopeDetails addedCommits;
    private final String previousFromHash;
    private final String previousToHash;
    private final boolean fromHashUpdated;
    private final boolean toHashUpdated;
    private final RescopeDetails removedCommits;

    public PullRequestRescopedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull String previousFromHash, @Nonnull String previousToHash) {
        this(source, pullRequest, previousFromHash, previousToHash, null, null);
    }

    public PullRequestRescopedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull String previousFromHash, @Nonnull String previousToHash, @Nullable RescopeDetails addedCommits, @Nullable RescopeDetails removedCommits) {
        super(source, pullRequest, PullRequestAction.RESCOPED);
        this.previousFromHash = Objects.requireNonNull(previousFromHash, "previousFromHash");
        this.previousToHash = Objects.requireNonNull(previousToHash, "previousToHash");
        this.addedCommits = addedCommits;
        this.removedCommits = removedCommits;
        this.fromHashUpdated = !Objects.equals(pullRequest.getFromRef().getLatestCommit(), previousFromHash);
        this.toHashUpdated = !Objects.equals(pullRequest.getToRef().getLatestCommit(), previousToHash);
    }

    @Nullable
    public RescopeDetails getAddedCommits() {
        return this.addedCommits;
    }

    @Nonnull
    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return this.previousToHash;
    }

    @Nullable
    public RescopeDetails getRemovedCommits() {
        return this.removedCommits;
    }

    public boolean isFromHashUpdated() {
        return this.fromHashUpdated;
    }

    public boolean isToHashUpdated() {
        return this.toHashUpdated;
    }
}

