/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MeshNode {
    public long getId();

    @Nullable
    public Date getLastSeenDate();

    @Nonnull
    @RequiredString
    public String getName();

    @Nonnull
    default public String getRpcId() {
        return Long.toString(this.getId());
    }

    @Nonnull
    @RequiredString
    public String getRpcUrl();

    @Nonnull
    public State getState();

    public boolean isAvailable();

    public boolean isOffline();

    default public boolean isSidecar() {
        return false;
    }

    public static enum State {
        AVAILABLE(1, "Available"),
        DELETING(2, "Deleting"),
        DISABLED(3, "Disabled"),
        DRAINING(4, "Draining"),
        OFFLINE(5, "Offline");

        private final int id;
        private final String statusMessage;

        private State(int id, String statusMessage) {
            this.id = id;
            this.statusMessage = Objects.requireNonNull(statusMessage, "statusMessage");
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getStatusMessage() {
            return this.statusMessage;
        }

        public static State fromId(int id) {
            for (State value : State.values()) {
                if (value.getId() != id) continue;
                return value;
            }
            throw new IllegalArgumentException("No Mesh.State is associated with ID [" + id + "]");
        }
    }
}

