/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PullRequestCreateRequest {
    private final String description;
    private final String fromRefId;
    private final Repository fromRepository;
    private final Set<String> reviewers;
    private final String title;
    private final String toBranchId;
    private final Repository toRepository;

    protected PullRequestCreateRequest(@Nonnull AbstractBuilder<?> builder) {
        this.title = Objects.requireNonNull(((AbstractBuilder)builder).title, "title");
        this.description = ((AbstractBuilder)builder).description;
        this.fromRepository = Objects.requireNonNull(((AbstractBuilder)builder).fromRepository, "fromRepository");
        this.fromRefId = Objects.requireNonNull(((AbstractBuilder)builder).fromRefId, "fromRefId");
        this.reviewers = ((AbstractBuilder)builder).reviewers.build();
        this.toRepository = Objects.requireNonNull(((AbstractBuilder)builder).toRepository, "toRepository");
        this.toBranchId = Objects.requireNonNull(((AbstractBuilder)builder).toBranchId, "toBranchId");
    }

    @Nonnull
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Nonnull
    public String getFromRefId() {
        return this.fromRefId;
    }

    @Nonnull
    public Repository getFromRepository() {
        return this.fromRepository;
    }

    @Nonnull
    public Set<String> getReviewers() {
        return this.reviewers;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getToBranchId() {
        return this.toBranchId;
    }

    @Nonnull
    public Repository getToRepository() {
        return this.toRepository;
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends BuilderSupport {
        private String description;
        private String fromRefId;
        private Repository fromRepository;
        private ImmutableSet.Builder<String> reviewers = ImmutableSet.builder();
        private String title;
        private String toBranchId;
        private Repository toRepository;

        protected AbstractBuilder() {
        }

        @Nonnull
        public abstract PullRequestCreateRequest build();

        @Nonnull
        public T description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public T fromRefId(@Nonnull String value) {
            this.fromRefId = Objects.requireNonNull(StringUtils.trimToNull((String)value), "fromRefId");
            return this.self();
        }

        @Nonnull
        public T fromRepository(@Nonnull Repository value) {
            this.fromRepository = Objects.requireNonNull(value, "fromRepository");
            return this.self();
        }

        @Nonnull
        public T repository(@Nonnull Repository value) {
            this.fromRepository = this.toRepository = Objects.requireNonNull(value, "repository");
            return this.self();
        }

        @Nonnull
        public T reviewer(@Nonnull String value) {
            AbstractBuilder.addIf(Objects::nonNull, this.reviewers, value);
            return this.self();
        }

        @Nonnull
        public T reviewers(@Nonnull Set<String> value) {
            AbstractBuilder.addIf(Objects::nonNull, this.reviewers, value);
            return this.self();
        }

        @Nonnull
        public T title(@Nonnull String value) {
            this.title = Objects.requireNonNull(StringUtils.trimToNull((String)value), "title");
            return this.self();
        }

        @Nonnull
        public T toBranchId(@Nonnull String value) {
            this.toBranchId = Objects.requireNonNull(StringUtils.trimToNull((String)value), "toBranchId");
            return this.self();
        }

        @Nonnull
        public T toRepository(@Nonnull Repository value) {
            this.toRepository = Objects.requireNonNull(value, "toRepository");
            return this.self();
        }

        @Nonnull
        protected abstract T self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        @Override
        @Nonnull
        public PullRequestCreateRequest build() {
            return new PullRequestCreateRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

