/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryCloneLinksRequest {
    private final Repository repository;
    private final String protocolName;
    private final ApplicationUser user;
    private final boolean useCurrentUser;

    private RepositoryCloneLinksRequest(@Nonnull Builder builder) {
        Objects.requireNonNull(builder, "builder");
        Preconditions.checkArgument((!builder.useCurrentUser || builder.user == null ? 1 : 0) != 0, (Object)"A user cannot be supplied if the current authenticated user is to be used for clone link generation");
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.protocolName = builder.protocolName;
        this.user = builder.user;
        this.useCurrentUser = builder.useCurrentUser;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getProtocolName() {
        return this.protocolName;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean isUseCurrentUser() {
        return this.useCurrentUser;
    }

    public static class Builder {
        private Repository repository;
        private String protocolName;
        private ApplicationUser user;
        private boolean useCurrentUser = true;

        public Builder protocol(@Nullable String value) {
            this.protocolName = value;
            return this;
        }

        public Builder repository(@Nonnull Repository value) {
            this.repository = value;
            return this;
        }

        public Builder user(@Nullable ApplicationUser value) {
            this.useCurrentUser = false;
            this.user = value;
            return this;
        }

        @Nonnull
        public RepositoryCloneLinksRequest build() {
            return new RepositoryCloneLinksRequest(this);
        }
    }
}

