/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DiffCommandParameters
extends AbstractDiffCommandParameters {
    private final String sinceId;
    private final String untilId;

    private DiffCommandParameters(Builder builder) {
        super(builder);
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    @Nonnull
    public DiffContext toContext() {
        return this.toContext(new DiffContext.Builder(this.getSinceId(), this.getUntilId()));
    }

    public static class Builder
    extends AbstractDiffCommandParameters.AbstractBuilder<Builder> {
        private String sinceId;
        private String untilId;

        @Nonnull
        public DiffCommandParameters build() {
            if (StringUtils.isBlank((CharSequence)this.untilId)) {
                throw new IllegalStateException("An \"until\" ID is required to build a diff");
            }
            return new DiffCommandParameters(this);
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = value;
            return this;
        }

        @Nonnull
        public Builder untilId(@Nonnull String value) {
            this.untilId = value;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

