/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class FilteredPageImpl<T>
implements Page<T> {
    private final boolean lastPage;
    private final int nextOrdinal;
    private final PageRequest pageRequest;
    private final int size;
    private final SortedMap<Integer, T> valueMap;

    public FilteredPageImpl(@Nonnull PageRequest pageRequest, int size, @Nonnull SortedMap<Integer, T> valueMap, boolean lastPage) {
        this.pageRequest = pageRequest;
        this.size = size;
        this.lastPage = lastPage;
        if (valueMap.size() > size) {
            this.nextOrdinal = (Integer)Iterables.get(valueMap.keySet(), (int)size);
            this.valueMap = valueMap.headMap(this.nextOrdinal);
        } else {
            this.valueMap = valueMap;
            this.nextOrdinal = valueMap.isEmpty() ? -1 : valueMap.lastKey() + 1;
        }
    }

    @Override
    public void forEach(@Nonnull Consumer<? super T> action) {
        this.valueMap.values().forEach(action);
    }

    @Override
    public boolean getIsLastPage() {
        return this.lastPage;
    }

    @Override
    public int getLimit() {
        return this.pageRequest.getLimit();
    }

    @Override
    public PageRequest getNextPageRequest() {
        if (this.lastPage) {
            return null;
        }
        return new PageRequestImpl(this.nextOrdinal, this.pageRequest.getLimit());
    }

    @Override
    @Nonnull
    public SortedMap<Integer, T> getOrdinalIndexedValues() {
        return this.valueMap;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getStart() {
        return this.pageRequest.getStart();
    }

    @Override
    @Nonnull
    public Iterable<T> getValues() {
        return this.valueMap.values();
    }

    @Override
    @Nonnull
    public Stream<T> stream() {
        return this.valueMap.values().stream();
    }

    @Override
    @Nonnull
    public <E> FilteredPageImpl<E> transform(@Nonnull Function<? super T, ? extends E> transformFunction) {
        TreeMap transformedValueMap = new TreeMap(Maps.transformValues(this.valueMap, transformFunction::apply));
        return new FilteredPageImpl(this.pageRequest, this.size, transformedValueMap, this.lastPage);
    }
}

