/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.directory.DbCachingDirectoryPoller;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.base.Objects;
import java.util.Map;

public class DirectoryPollerJobRunner
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)DirectoryPollerManager.class.getName());
    public static final String PARAM_DIRECTORY_ID = "DIRECTORY_ID";
    public static final String PARAM_SYNC_MODE = "SYNC_MODE";
    private final DirectoryManager directoryManager;
    private final DirectorySynchroniser directorySynchroniser;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final SchedulerService schedulerService;

    public DirectoryPollerJobRunner(DirectoryManager directoryManager, DirectorySynchroniser directorySynchroniser, DirectoryInstanceLoader directoryInstanceLoader, SchedulerService schedulerService) {
        this.directoryManager = directoryManager;
        this.directorySynchroniser = directorySynchroniser;
        this.directoryInstanceLoader = directoryInstanceLoader;
        this.schedulerService = schedulerService;
    }

    public void register() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        RemoteDirectory remoteDirectory;
        Directory directory;
        Map params = request.getJobConfig().getParameters();
        long directoryId = (Long)params.get(PARAM_DIRECTORY_ID);
        SynchronisationMode syncMode = (SynchronisationMode)Objects.firstNonNull((Object)((SynchronisationMode)params.get(PARAM_SYNC_MODE)), (Object)SynchronisationMode.INCREMENTAL);
        try {
            directory = this.directoryManager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            return JobRunnerResponse.aborted((String)("Cannot synchronise unknown directory [ " + directoryId + " ]"));
        }
        try {
            remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
        }
        catch (DirectoryInstantiationException e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
        if (!(remoteDirectory instanceof SynchronisableDirectory)) {
            return JobRunnerResponse.aborted((String)("Directory is not synchronisable. [ " + directoryId + " ]"));
        }
        DbCachingDirectoryPoller poller = new DbCachingDirectoryPoller(this.directorySynchroniser, (SynchronisableDirectory)remoteDirectory);
        poller.pollChanges(syncMode);
        return JobRunnerResponse.success();
    }

    public void unregister() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }
}

