/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.property;

import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.mail.SMTPServer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.mail.internet.InternetAddress;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PropertyManagerGeneric
implements PropertyManager {
    private PropertyDAO propertyDAO;
    private static final Logger logger = LoggerFactory.getLogger(PropertyManagerGeneric.class);
    private static final int DEFAULT_SESSION_TIME_IN_MINUTES = 5;

    public PropertyManagerGeneric(PropertyDAO propertyDAO) {
        this.propertyDAO = propertyDAO;
    }

    public String getDeploymentTitle() throws PropertyManagerException {
        try {
            Property property = this.getPropertyObject("deployment.title");
            return property.getValue();
        }
        catch (Exception e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setDeploymentTitle(String title) {
        this.setProperty("deployment.title", title);
    }

    public String getDomain() throws PropertyManagerException {
        String domain;
        block2: {
            domain = null;
            try {
                Property property = this.getPropertyObject("domain");
                domain = property.getValue();
            }
            catch (ObjectNotFoundException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Failed to find a domain property.");
            }
        }
        return domain;
    }

    public void setDomain(String domain) {
        this.setProperty("domain", domain);
    }

    public boolean isSecureCookie() {
        try {
            Property property = this.getPropertyObject("secure.cookie");
            return Boolean.parseBoolean(property.getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setSecureCookie(boolean secure) {
        this.setProperty("secure.cookie", Boolean.toString(secure));
    }

    public void setCacheEnabled(boolean enabled) {
        this.setProperty("cache.enabled", Boolean.toString(enabled));
    }

    public boolean isCacheEnabled() {
        try {
            Property property = this.getPropertyObject("cache.enabled");
            return Boolean.parseBoolean(property.getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getSessionTime() {
        try {
            Property property = this.getPropertyObject("session.time");
            long b = Long.parseLong(property.getValue());
            return TimeUnit.MILLISECONDS.toMinutes(b);
        }
        catch (Exception e) {
            return 5L;
        }
    }

    public void setSessionTime(long time) {
        this.setProperty("session.time", Long.toString(TimeUnit.MINUTES.toMillis(time)));
    }

    public SMTPServer getSMTPServer() throws PropertyManagerException {
        SMTPServer server;
        InternetAddress fromAddress;
        try {
            fromAddress = new InternetAddress(this.getPropertyObject("mailserver.sender").getValue());
        }
        catch (Exception e) {
            throw new PropertyManagerException((Throwable)e);
        }
        String prefix = null;
        try {
            prefix = this.getPropertyObject("mailserver.prefix").getValue();
        }
        catch (ObjectNotFoundException ignored) {
            // empty catch block
        }
        try {
            server = this.buildJNDIServer(fromAddress, prefix);
        }
        catch (ObjectNotFoundException ignored) {
            server = this.buildSMTPServer(fromAddress, prefix);
        }
        return server;
    }

    private SMTPServer buildJNDIServer(InternetAddress fromAddress, String prefix) throws ObjectNotFoundException {
        String jndiLocation = this.getPropertyObject("mailserver.jndi").getValue();
        if (StringUtils.isNotBlank((CharSequence)jndiLocation)) {
            return new SMTPServer(jndiLocation, fromAddress, prefix);
        }
        throw new ObjectNotFoundException(Property.class, (Object)"JNDI location");
    }

    private SMTPServer buildSMTPServer(InternetAddress fromAddress, String prefix) throws PropertyManagerException {
        String host;
        try {
            host = this.getPropertyObject("mailserver.host").getValue();
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException((Throwable)e);
        }
        String password = null;
        try {
            password = this.getPropertyObject("mailserver.password").getValue();
        }
        catch (ObjectNotFoundException ignored) {
            // empty catch block
        }
        String username = null;
        try {
            username = this.getPropertyObject("mailserver.username").getValue();
        }
        catch (ObjectNotFoundException ignored) {
            // empty catch block
        }
        int port = 25;
        try {
            String value = this.getPropertyObject("mailserver.port").getValue();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                port = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("SMTP port number was not a valid number", e);
        }
        catch (ObjectNotFoundException ignored) {
            // empty catch block
        }
        boolean useSSL = false;
        try {
            useSSL = Boolean.valueOf(this.getPropertyObject("mailserver.usessl").getValue());
        }
        catch (ObjectNotFoundException ignored) {
            // empty catch block
        }
        return new SMTPServer(port, prefix, fromAddress, password, username, host, useSSL);
    }

    public void setSMTPServer(SMTPServer server) {
        this.setProperty("mailserver.prefix", server.getPrefix());
        this.setProperty("mailserver.sender", server.getFrom().toString());
        if (StringUtils.isNotBlank((CharSequence)server.getJndiLocation())) {
            this.setProperty("mailserver.jndi", server.getJndiLocation());
            this.setProperty("mailserver.host", "");
            this.setProperty("mailserver.password", "");
            this.setProperty("mailserver.username", "");
            this.setProperty("mailserver.port", "");
            this.setProperty("mailserver.usessl", "");
        } else {
            this.setProperty("mailserver.host", server.getHost());
            this.setProperty("mailserver.password", server.getPassword());
            this.setProperty("mailserver.username", server.getUsername());
            this.setProperty("mailserver.port", String.valueOf(server.getPort()));
            this.setProperty("mailserver.usessl", String.valueOf(server.getUseSSL()));
            this.setProperty("mailserver.jndi", "");
        }
    }

    public Key getDesEncryptionKey() throws PropertyManagerException {
        try {
            String keyStr = this.getPropertyObject("des.encryption.key").getValue();
            DESKeySpec ks = new DESKeySpec(Base64.decodeBase64((String)keyStr));
            return SecretKeyFactory.getInstance("DES").generateSecret(ks);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void generateDesEncryptionKey() throws PropertyManagerException {
        try {
            try {
                this.getPropertyObject("des.encryption.key");
                return;
            }
            catch (Exception e) {
                SecretKey key = KeyGenerator.getInstance("DES").generateKey();
                this.setProperty("des.encryption.key", Base64.encodeBase64String((byte[])key.getEncoded()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public void setSMTPTemplate(String template) {
        this.setProperty("mailserver.message.template", template);
    }

    @Deprecated
    public String getSMTPTemplate() throws PropertyManagerException {
        try {
            Property property = this.getPropertyObject("mailserver.message.template");
            return property.getValue();
        }
        catch (Exception e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setCurrentLicenseResourceTotal(int total) {
        this.setProperty("current.license.resource.total", Integer.toString(total));
    }

    public int getCurrentLicenseResourceTotal() {
        int total = 0;
        try {
            total = Integer.parseInt(this.getPropertyObject("current.license.resource.total").getValue());
        }
        catch (Exception e) {
            logger.debug("Failed to find current resource total.", (Throwable)e);
        }
        return total;
    }

    public void setNotificationEmail(String notificationEmail) {
        this.setProperty("notification.email", notificationEmail);
    }

    public String getNotificationEmail() throws PropertyManagerException {
        try {
            return this.getPropertyObject("notification.email").getValue();
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isGzipEnabled() throws PropertyManagerException {
        try {
            Property property = this.getPropertyObject("gzip.enabled");
            return Boolean.parseBoolean(property.getValue());
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setGzipEnabled(boolean gzip) {
        this.setProperty("gzip.enabled", Boolean.toString(gzip));
    }

    public Integer getBuildNumber() throws PropertyManagerException {
        try {
            return Integer.valueOf(this.getPropertyObject("build.number").getValue());
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setBuildNumber(Integer buildNumber) {
        this.setProperty("build.number", buildNumber.toString());
    }

    public String getTrustedProxyServers() throws PropertyManagerException {
        try {
            return this.getPropertyObject("trusted.proxy.servers").getValue();
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void setTrustedProxyServers(String proxyServers) {
        this.setProperty("trusted.proxy.servers", proxyServers);
    }

    public boolean isUsingDatabaseTokenStorage() throws PropertyManagerException {
        boolean usingDatabaseStorage;
        try {
            usingDatabaseStorage = Boolean.parseBoolean(this.getPropertyObject("database.token.storage.enabled").getValue());
        }
        catch (ObjectNotFoundException e) {
            usingDatabaseStorage = true;
        }
        return usingDatabaseStorage;
    }

    public void setUsingDatabaseTokenStorage(boolean usingMemoryTokenStorage) {
        this.setProperty("database.token.storage.enabled", Boolean.toString(usingMemoryTokenStorage));
    }

    public boolean isIncludeIpAddressInValidationFactors() {
        try {
            return Boolean.parseBoolean(this.getPropertyObject("validation.factors.include_ip_address").getValue());
        }
        catch (ObjectNotFoundException e) {
            return true;
        }
    }

    public void setIncludeIpAddressInValidationFactors(boolean includeIpAddressInValidationFactors) {
        this.setProperty("validation.factors.include_ip_address", Boolean.toString(includeIpAddressInValidationFactors));
    }

    public void removeProperty(String name) {
        this.propertyDAO.remove("crowd", name);
    }

    protected Property getPropertyObject(String name) throws ObjectNotFoundException {
        return this.propertyDAO.find("crowd", name);
    }

    public String getProperty(String name) throws ObjectNotFoundException {
        Property property = this.getPropertyObject(name);
        return property.getValue();
    }

    public void setProperty(String name, String value) {
        Property property = null;
        try {
            property = this.getPropertyObject(name);
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        if (property == null) {
            property = new Property("crowd", name, value);
        } else {
            property.setValue(value);
        }
        this.propertyDAO.update(property);
    }

    public String getString(String property, String defaultValue) {
        try {
            return this.getProperty(property);
        }
        catch (ObjectNotFoundException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String property, boolean defaultValue) {
        try {
            String value = this.getProperty(property);
            return Boolean.valueOf(value);
        }
        catch (ObjectNotFoundException e) {
            return defaultValue;
        }
    }

    public int getInt(String property, int defaultValue) {
        String value = null;
        try {
            value = this.getProperty(property);
            return Integer.parseInt(value);
        }
        catch (ObjectNotFoundException e) {
            return defaultValue;
        }
        catch (NumberFormatException e) {
            logger.warn("Corrupted value found for property {}. Found {} instead of an integer", (Object)property, (Object)value);
            return defaultValue;
        }
    }
}

