/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.name;

import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.ImmutableLdapName;
import com.atlassian.crowd.directory.ldap.name.LdapNameFormatException;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.List;
import java.util.ListIterator;
import java.util.StringJoiner;
import javax.naming.ldap.Rdn;

public final class CrowdLdapNameFactory {
    private final Cache<String, ImmutableLdapName> cache = Caffeine.newBuilder().recordStats().build();
    private final Stats cacheStats = new Stats();

    private CrowdLdapNameFactory() {
    }

    public static CrowdLdapNameFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public CrowdLdapName getEmptyLdapName() {
        return this.get("");
    }

    public CrowdLdapName get(List<Rdn> rdnList) {
        return this.get(CrowdLdapNameFactory.convertToDnString(rdnList));
    }

    public CrowdLdapName get(String dn) throws LdapNameFormatException {
        return (CrowdLdapName)this.cache.get((Object)dn, ImmutableLdapName::new);
    }

    public synchronized void clearCache() {
        this.cache.invalidateAll();
        this.resetMetrics();
    }

    public synchronized void resetMetrics() {
        this.cacheStats.resetMetrics();
    }

    public synchronized String getStatsSummary() {
        return this.cacheStats.getStats();
    }

    private static String convertToDnString(List<Rdn> rdnList) {
        StringJoiner stringJoiner = new StringJoiner(",");
        ListIterator<Rdn> rdnIterator = rdnList.listIterator(rdnList.size());
        while (rdnIterator.hasPrevious()) {
            stringJoiner.add(rdnIterator.previous().toString());
        }
        return stringJoiner.toString();
    }

    public long getCacheSize() {
        return this.cache.estimatedSize();
    }

    private class Stats {
        private long initialCacheSize;
        private long startTime;
        private CacheStats previousStats;

        Stats() {
            this.resetMetrics();
        }

        void resetMetrics() {
            this.startTime = System.currentTimeMillis();
            this.initialCacheSize = CrowdLdapNameFactory.this.getCacheSize();
            this.previousStats = CrowdLdapNameFactory.this.cache.stats();
        }

        public String getStats() {
            CacheStats stats = CrowdLdapNameFactory.this.cache.stats().minus(this.previousStats);
            long totalTime = System.currentTimeMillis() - this.startTime;
            return String.format("[LdapName cache] Total running time: %sms. Initial cache size: %s. Total cache size: %s. Cache requested %s times [%s hits, %s misses]. Cache hit of %.2f%%.", totalTime, this.initialCacheSize, CrowdLdapNameFactory.this.getCacheSize(), stats.requestCount(), stats.hitCount(), stats.missCount(), stats.hitRate() * 100.0);
        }
    }

    private static class SingletonHolder {
        private static final CrowdLdapNameFactory INSTANCE = new CrowdLdapNameFactory();

        private SingletonHolder() {
        }
    }
}

