/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.provider;

import com.atlassian.crowd.manager.permission.UserPermissionException;
import com.atlassian.crowd.manager.permission.UserPermissionService;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.crowd.plugin.rest.exception.AnonymousUserPermissionRuntimeException;
import com.atlassian.crowd.plugin.rest.provider.SysAdminPermissionOnly;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=2000)
@SysAdminPermissionOnly
public class SysAdminPermissionFilter
implements ContainerRequestFilter {
    private final UserPermissionService userPermissionService;
    private UserManager userManager;

    @Inject
    public SysAdminPermissionFilter(@ComponentImport UserPermissionService userPermissionService, @ComponentImport UserManager userManager) {
        this.userPermissionService = userPermissionService;
        this.userManager = userManager;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.userManager.getRemoteUserKey() == null) {
            throw new AnonymousUserPermissionRuntimeException("You must be logged in to access this resource.");
        }
        if (!this.userPermissionService.currentUserHasPermission(UserPermission.SYS_ADMIN)) {
            throw new UserPermissionException("You must be an administrator to access this resource.");
        }
    }
}

