/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.internal.SingleParameterMethodListenerInvoker;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedMethodsListenerHandler
implements ListenerHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class annotationClass;

    public AnnotatedMethodsListenerHandler() {
        this(EventListener.class);
    }

    public AnnotatedMethodsListenerHandler(Class annotationClass) {
        this.annotationClass = (Class)Preconditions.checkNotNull((Object)annotationClass);
    }

    @Override
    public List<? extends ListenerInvoker> getInvokers(Object listener) {
        Map<Method, Optional<String>> validMethods = this.getValidMethods(Preconditions.checkNotNull((Object)listener));
        if (validMethods.isEmpty()) {
            this.log.debug("Couldn't find any valid listener methods on class <{}>", (Object)listener.getClass().getName());
        }
        return validMethods.entrySet().stream().map(entry -> new SingleParameterMethodListenerInvoker(listener, (Method)entry.getKey(), (Optional)entry.getValue())).collect(Collectors.toCollection(LinkedList::new));
    }

    private Map<Method, Optional<String>> getValidMethods(Object listener) {
        LinkedHashMap<Method, Optional<String>> annotatedMethods = new LinkedHashMap<Method, Optional<String>>();
        for (Method method : listener.getClass().getMethods()) {
            if (!this.isValidMethod(method)) continue;
            annotatedMethods.put(method, this.getScope(method));
        }
        return annotatedMethods;
    }

    private Optional<String> getScope(Method method) {
        EventListener annotation = method.getAnnotation(EventListener.class);
        return Optional.ofNullable(annotation).map(EventListener::scope).filter(scopeName -> !"".equals(scopeName));
    }

    private boolean isValidMethod(Method method) {
        if (this.isAnnotated(method)) {
            if (this.hasOneAndOnlyOneParameter(method)) {
                return true;
            }
            throw new RuntimeException("Method <" + method + "> of class <" + method.getDeclaringClass() + "> is annotated with <" + this.annotationClass.getName() + "> but has 0 or more than 1 parameters! Listener methods MUST have 1 and only 1 parameter.");
        }
        return false;
    }

    private boolean isAnnotated(Method method) {
        return method.getAnnotation(this.annotationClass) != null;
    }

    private boolean hasOneAndOnlyOneParameter(Method method) {
        return method.getParameterTypes().length == 1;
    }
}

