/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.ClassUtils;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.plugin.eventlistener.descriptors.EventListenerModuleDescriptor;
import com.atlassian.plugin.scope.EverythingIsActiveScopeManager;
import com.atlassian.plugin.scope.ScopeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventPublisherImpl
implements EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(EventPublisherImpl.class);
    private static final String PROPERTY_PREFIX = EventPublisherImpl.class.getName();
    private static final Optional<String> debugRegistration = Optional.ofNullable(System.getProperty(PROPERTY_PREFIX + ".debugRegistration"));
    private static final boolean debugRegistrationLocation = Boolean.getBoolean(PROPERTY_PREFIX + ".debugRegistrationLocation");
    private static final Optional<String> debugInvocation = Optional.ofNullable(System.getProperty(PROPERTY_PREFIX + ".debugInvocation"));
    private static final boolean debugInvocationLocation = Boolean.getBoolean(PROPERTY_PREFIX + ".debugInvocationLocation");
    private final EventDispatcher eventDispatcher;
    private final List<ListenerHandler> listenerHandlers;
    private final ScopeManager scopeManager;
    private final Multimap<Class<?>, KeyedListenerInvoker> listenerInvokers;

    public EventPublisherImpl(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this(eventDispatcher, listenerHandlersConfiguration, (ScopeManager)new EverythingIsActiveScopeManager());
    }

    public EventPublisherImpl(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration, ScopeManager scopeManager) {
        this.eventDispatcher = (EventDispatcher)Preconditions.checkNotNull((Object)eventDispatcher);
        this.listenerHandlers = (List)Preconditions.checkNotNull(((ListenerHandlersConfiguration)Preconditions.checkNotNull((Object)listenerHandlersConfiguration)).getListenerHandlers());
        this.listenerInvokers = this.newMultimap();
        this.scopeManager = (ScopeManager)Preconditions.checkNotNull((Object)scopeManager);
    }

    @Override
    public void publish(@Nonnull Object event) {
        this.invokeListeners(this.findListenerInvokersForEvent(Preconditions.checkNotNull((Object)event)), event);
    }

    @Override
    public void register(@Nonnull Object listener) {
        this.registerListener(ObjectUtils.identityToString((Object)Preconditions.checkNotNull((Object)listener)), listener);
    }

    @Override
    public void unregister(@Nonnull Object listener) {
        this.unregisterListener(ObjectUtils.identityToString((Object)Preconditions.checkNotNull((Object)listener)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAll() {
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.listenerInvokers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(String listenerKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)listenerKey), (Object)"Key for the listener must not be empty");
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.listenerInvokers.entries().removeIf(entry -> ((KeyedListenerInvoker)entry.getValue()).getKey().equals(listenerKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(String listenerKey, Object listener) {
        Optional parentScope;
        Object listenerImpl;
        if (listener instanceof EventListenerModuleDescriptor) {
            EventListenerModuleDescriptor descriptor = (EventListenerModuleDescriptor)listener;
            listenerImpl = descriptor.getModule();
            parentScope = descriptor.getScopeKey();
        } else {
            listenerImpl = listener;
            parentScope = Optional.empty();
        }
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            this.unregisterListener(listenerKey);
            ArrayList invokers = Lists.newArrayList();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                invokers.addAll(listenerHandler.getInvokers(listenerImpl));
            }
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listenerImpl + ">");
            }
            this.registerListenerInvokers(listenerKey, parentScope, invokers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<KeyedListenerInvoker> findListenerInvokersForEvent(Object event) {
        LinkedHashSet invokers = Sets.newLinkedHashSet();
        Multimap<Class<?>, KeyedListenerInvoker> multimap = this.listenerInvokers;
        synchronized (multimap) {
            for (Class<?> eventClass : ClassUtils.findAllTypes(Preconditions.checkNotNull((Object)event).getClass())) {
                invokers.addAll(this.listenerInvokers.get(eventClass));
            }
        }
        List activeInvokers = invokers.stream().filter(i -> i.getScope().map(arg_0 -> ((ScopeManager)this.scopeManager).isScopeActive(arg_0)).orElse(true)).collect(Collectors.toList());
        return Sets.newLinkedHashSet(activeInvokers);
    }

    private void invokeListeners(Collection<KeyedListenerInvoker> listenerInvokers, Object event) {
        String eventClass = event.getClass().getName();
        boolean debugThisInvocation = debugInvocation.map(eventClass::startsWith).orElse(false);
        for (KeyedListenerInvoker keyedInvoker : listenerInvokers) {
            ListenerInvoker invoker = keyedInvoker.getInvoker();
            if (debugThisInvocation) {
                log.warn("Listener invoked event with class '{}' -> invoker {}", (Object)eventClass, (Object)invoker);
                if (debugInvocationLocation) {
                    log.warn("Invoked from", (Throwable)new Exception());
                }
            }
            try {
                this.eventDispatcher.dispatch(invoker, event);
            }
            catch (Exception e) {
                log.error("There was an exception thrown trying to dispatch event '{}' from the invoker '{}'.", new Object[]{event, invoker, e});
            }
        }
    }

    private void registerListenerInvokers(String listenerKey, Optional<String> parentScope, List<? extends ListenerInvoker> invokers) {
        for (ListenerInvoker listenerInvoker : invokers) {
            this.registerListenerInvoker(listenerKey, parentScope, listenerInvoker);
        }
    }

    private void registerListenerInvoker(String listenerKey, Optional<String> parentScope, ListenerInvoker invoker) {
        if (invoker.getSupportedEventTypes().isEmpty()) {
            this.putEventListenerInvoker(Object.class, listenerKey, parentScope, invoker);
        }
        for (Class<?> eventClass : invoker.getSupportedEventTypes()) {
            this.putEventListenerInvoker(eventClass, listenerKey, parentScope, invoker);
        }
    }

    private void putEventListenerInvoker(Class<?> eventClass, String listenerKey, Optional<String> parentScope, ListenerInvoker invoker) {
        debugRegistration.ifPresent(classPrefix -> {
            if (eventClass.getName().startsWith((String)classPrefix)) {
                log.warn("Listener registered event '{}' -> invoker {}", (Object)eventClass, (Object)invoker);
                if (debugRegistrationLocation) {
                    log.warn("Registered from", (Throwable)new Exception());
                }
            }
        });
        log.debug("Registering {} with scope {}", (Object)listenerKey, parentScope);
        if (parentScope.isPresent() && invoker.getScope().isPresent() && !parentScope.equals(invoker.getScope())) {
            throw new IllegalArgumentException("Listener <" + listenerKey + "> tries to override parent scope <" + parentScope.get() + "> with <" + invoker.getScope() + ">");
        }
        Optional<String> invokerScope = parentScope.isPresent() ? parentScope : invoker.getScope();
        this.listenerInvokers.put(eventClass, (Object)new KeyedListenerInvoker(listenerKey, invoker, invokerScope));
    }

    private Multimap<Class<?>, KeyedListenerInvoker> newMultimap() {
        return Multimaps.synchronizedMultimap((Multimap)Multimaps.newMultimap(new HashMap(), HashSet::new));
    }

    private static final class KeyedListenerInvoker {
        private final String key;
        private final ListenerInvoker invoker;
        private final Optional<String> scope;

        KeyedListenerInvoker(String key, ListenerInvoker invoker, Optional<String> scope) {
            this.invoker = invoker;
            this.key = key;
            this.scope = scope;
        }

        String getKey() {
            return this.key;
        }

        ListenerInvoker getInvoker() {
            return this.invoker;
        }

        Optional<String> getScope() {
            return this.scope;
        }

        public int hashCode() {
            return new HashCodeBuilder(5, 23).append((Object)this.key).append((Object)this.invoker).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            KeyedListenerInvoker kli = (KeyedListenerInvoker)obj;
            return new EqualsBuilder().append((Object)this.key, (Object)kli.key).append((Object)this.invoker, (Object)kli.invoker).append(this.scope, kli.scope).isEquals();
        }
    }
}

