/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class CustomFilterData {
    private String title;
    private String states;
    private String author;
    private String moderator;
    private String creator;
    private String reviewer;
    private boolean orRoles = false;
    private Boolean complete = null;
    private Boolean allReviewersComplete = null;
    private String project;
    private long fromDate;
    private long toDate;

    public CustomFilterData() {
    }

    public CustomFilterData(String title, String states, String author, String moderator, String creator, String reviewer, boolean orRoles, Boolean complete, Boolean allReviewersComplete, String project) {
        this(title, states, author, moderator, creator, reviewer, orRoles, complete, allReviewersComplete, project, 0L, 0L);
    }

    public CustomFilterData(String title, String states, String author, String moderator, String creator, String reviewer, boolean orRoles, Boolean complete, Boolean allReviewersComplete, String project, long fromDate, long toDate) {
        if (fromDate > 0L && toDate > 0L && fromDate >= toDate) {
            throw new IllegalArgumentException(String.format("invalid date filter: fromDate (%d) >= toDate (%d)", fromDate, toDate));
        }
        this.title = title;
        this.states = states;
        this.author = author;
        this.moderator = moderator;
        this.creator = creator;
        this.reviewer = reviewer;
        this.orRoles = orRoles;
        this.complete = complete;
        this.allReviewersComplete = allReviewersComplete;
        this.project = project;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getState() {
        return this.states;
    }

    public void setState(String states) {
        this.states = states;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getModerator() {
        return this.moderator;
    }

    public void setModerator(String moderator) {
        this.moderator = moderator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Boolean isComplete() {
        return this.complete;
    }

    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public Boolean isAllReviewersComplete() {
        return this.allReviewersComplete;
    }

    public void setAllReviewersComplete(Boolean allReviewersComplete) {
        this.allReviewersComplete = allReviewersComplete;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public boolean isOrRoles() {
        return this.orRoles;
    }

    public void setOrRoles(boolean orRoles) {
        this.orRoles = orRoles;
    }

    public long getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(long fromDate) {
        this.fromDate = fromDate;
    }

    public long getToDate() {
        return this.toDate;
    }

    public void setToDate(long toDate) {
        this.toDate = toDate;
    }
}

