/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.Actions;
import com.atlassian.crucible.spi.data.CommentStats;
import com.atlassian.crucible.spi.data.Comments;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItems;
import com.atlassian.crucible.spi.data.Reviewers;
import com.atlassian.crucible.spi.data.Transitions;
import com.atlassian.crucible.spi.data.UserData;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class DetailedReviewData
extends ReviewData {
    private Reviewers reviewers;
    private ReviewItems reviewItems;
    private Comments generalComments;
    private Comments versionedComments;
    private Transitions transitions;
    private Actions actions;
    @XmlElementWrapper(name="stats")
    @XmlElement(name="comments")
    public Collection<CommentStats> commentStats;

    public DetailedReviewData() {
    }

    public DetailedReviewData(String projectKey, String name, String description, UserData author, UserData moderator, UserData creator, String permaId, String summary, ReviewData.State state, boolean allowReviewerToJoin, PermId<ReviewData> parentReview, Date createDate, Date closeDate, Date dueDate, int metricsVersion, String jiraIssueKey) {
        super(projectKey, name, description, author, moderator, creator, permaId, summary, state, allowReviewerToJoin, parentReview, createDate, closeDate, dueDate, metricsVersion, jiraIssueKey);
    }

    public DetailedReviewData(String projectKey, String name, String description, UserData author, UserData moderator, UserData creator, String permaId, String summary, ReviewData.State state, ReviewData.ReviewType type, boolean allowReviewerToJoin, PermId<ReviewData> parentReview, Date createDate, Date closeDate, Date dueDate, int metricsVersion, String jiraIssueKey) {
        super(projectKey, name, description, author, moderator, creator, permaId, summary, state, type, allowReviewerToJoin, parentReview, createDate, closeDate, dueDate, metricsVersion, jiraIssueKey);
    }

    public DetailedReviewData(DetailedReviewData review) {
        super(review);
        this.actions = review.actions;
        this.generalComments = review.generalComments;
        this.reviewers = review.reviewers;
        this.reviewItems = review.reviewItems;
        this.transitions = review.transitions;
        this.versionedComments = review.versionedComments;
        this.commentStats = review.commentStats;
    }

    public DetailedReviewData(ReviewData review) {
        super(review);
    }

    public Reviewers getReviewers() {
        return this.reviewers;
    }

    public void setReviewers(Reviewers reviewers) {
        this.reviewers = reviewers;
    }

    public ReviewItems getReviewItems() {
        return this.reviewItems;
    }

    public void setReviewItems(ReviewItems reviewItems) {
        this.reviewItems = reviewItems;
    }

    public Comments getGeneralComments() {
        return this.generalComments;
    }

    public void setGeneralComments(Comments generalComments) {
        this.generalComments = generalComments;
    }

    public Comments getVersionedComments() {
        return this.versionedComments;
    }

    public void setVersionedComments(Comments versionedComments) {
        this.versionedComments = versionedComments;
    }

    public Transitions getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Transitions transitions) {
        this.transitions = transitions;
    }

    public Actions getActions() {
        return this.actions;
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    @XmlTransient
    public static class Builder
    extends ReviewData.Builder {
        private final DetailedReviewData detailedReviewData;

        public Builder() {
            this(new DetailedReviewData());
        }

        protected Builder(DetailedReviewData detailedReviewData) {
            super(detailedReviewData);
            this.detailedReviewData = detailedReviewData;
        }

        @Override
        public DetailedReviewData build() {
            return new DetailedReviewData(this.detailedReviewData);
        }

        public Builder setCommentStats(Collection<CommentStats> commentStats) {
            this.detailedReviewData.commentStats = commentStats;
            return this;
        }

        public Builder setActions(Actions actions) {
            this.detailedReviewData.setActions(actions);
            return this;
        }

        public Builder setGeneralComments(Comments generalComments) {
            this.detailedReviewData.setGeneralComments(generalComments);
            return this;
        }

        public Builder setReviewers(Reviewers reviewers) {
            this.detailedReviewData.setReviewers(reviewers);
            return this;
        }

        public Builder setReviewItems(ReviewItems reviewItems) {
            this.detailedReviewData.setReviewItems(reviewItems);
            return this;
        }

        public Builder setTransitions(Transitions transitions) {
            this.detailedReviewData.setTransitions(transitions);
            return this;
        }

        public Builder setVersionedComments(Comments versionedComments) {
            this.detailedReviewData.setVersionedComments(versionedComments);
            return this;
        }
    }
}

