/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import com.atlassian.crucible.spi.data.AnchorData;
import com.atlassian.crucible.spi.data.FisheyeReviewItemAttibutes;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.ReviewItemRevisionData;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="reviewItem")
public class FisheyeReviewItemData
extends ReviewItemData {
    private String repositoryName;
    private String fromPath;
    private String fromRevision;
    private String fromContentUrl;
    private String toPath;
    private String toRevision;
    private String toContentUrl;
    private String patchUrl;
    private FileType fileType;
    private CommitType commitType;
    private String authorName;
    private Boolean showAsDiff;
    private Collection<ReviewItemRevisionData> revisions;
    private AnchorData anchorData;
    private Date commitDate;

    public FisheyeReviewItemData() {
    }

    public FisheyeReviewItemData(String repositoryName, String fromPath, String fromRevision, String fromContentUrl, String toPath, String toRevision, String toContentUrl, FisheyeReviewItemAttibutes attrs, String permId, String patchUrl, FileType fileType, String authorName, Date commitDate, Boolean showAsDiff, Set<ReviewItemData.ParticipantStatus> participants) {
        this(repositoryName, fromPath, fromRevision, fromContentUrl, toPath, toRevision, toContentUrl, attrs, permId, patchUrl, null, fileType, authorName, commitDate, showAsDiff, participants, null);
    }

    public FisheyeReviewItemData(String repositoryName, String fromPath, String fromRevision, String fromContentUrl, String toPath, String toRevision, String toContentUrl, FisheyeReviewItemAttibutes attrs, String permId, String patchUrl, AnchorData anchorData, FileType fileType, String authorName, Date commitDate, Boolean showAsDiff, Set<ReviewItemData.ParticipantStatus> participants, Collection<ReviewItemRevisionData> revisions) {
        super(permId, participants);
        this.repositoryName = repositoryName;
        this.fromPath = fromPath;
        this.fromRevision = fromRevision;
        this.fromContentUrl = fromContentUrl;
        this.toPath = toPath;
        this.toRevision = toRevision;
        this.toContentUrl = toContentUrl;
        this.patchUrl = patchUrl;
        this.anchorData = anchorData;
        this.fileType = fileType;
        this.authorName = authorName;
        this.commitDate = commitDate;
        this.showAsDiff = showAsDiff;
        this.revisions = revisions;
        if (attrs != null) {
            if (attrs.isCopied()) {
                this.commitType = CommitType.Copied;
            }
            if (attrs.isMoved()) {
                this.commitType = CommitType.Moved;
            }
            if (attrs.isModified()) {
                this.commitType = CommitType.Modified;
            }
            if (attrs.isAdded()) {
                this.commitType = CommitType.Added;
            }
            if (attrs.isDeleted()) {
                this.commitType = CommitType.Deleted;
            }
        }
    }

    public AnchorData getAnchorData() {
        return this.anchorData;
    }

    public void setAnchorData(AnchorData anchorData) {
        this.anchorData = anchorData;
    }

    public void setExpandedRevisions(Collection<ReviewItemRevisionData> revisions) {
        this.revisions = revisions;
    }

    public Collection<ReviewItemRevisionData> getExpandedRevisions() {
        return this.revisions;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String getFromRevision() {
        return this.fromRevision;
    }

    public String getToPath() {
        return this.toPath;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setFromPath(String fromPath) {
        this.fromPath = fromPath;
    }

    public void setFromRevision(String fromRevision) {
        this.fromRevision = fromRevision;
    }

    public void setToPath(String toPath) {
        this.toPath = toPath;
    }

    public void setToRevision(String toRevision) {
        this.toRevision = toRevision;
    }

    public String getToRevision() {
        return this.toRevision;
    }

    public String getPatchUrl() {
        return this.patchUrl;
    }

    public void setPatchUrl(String patchUrl) {
        this.patchUrl = patchUrl;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public CommitType getCommitType() {
        return this.commitType;
    }

    public void setCommitType(CommitType commitType) {
        this.commitType = commitType;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public Date getCommitDate() {
        return this.commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public Boolean isShowAsDiff() {
        return this.showAsDiff;
    }

    public void setShowAsDiff(Boolean showAsDiff) {
        this.showAsDiff = showAsDiff;
    }

    public String getFromContentUrl() {
        return this.fromContentUrl;
    }

    public void setFromContentUrl(String fromContentUrl) {
        this.fromContentUrl = fromContentUrl;
    }

    public String getToContentUrl() {
        return this.toContentUrl;
    }

    public void setToContentUrl(String toContentUrl) {
        this.toContentUrl = toContentUrl;
    }

    public static enum CommitType {
        Added,
        Deleted,
        Modified,
        Moved,
        Copied,
        Unknown;

    }

    public static enum FileType {
        File,
        Directory,
        Unknown;

    }
}

