/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import com.atlassian.crucible.spi.data.UserData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class UserProfileData {
    private final UserData userData;
    private final TimeZone timeZone;
    private final Map<String, List<String>> mappedCommitters;
    private final String email;
    private final String avatarUrl;
    private final Map<String, Object> preferences;

    private UserProfileData() {
        this(null, null, null, null, null);
    }

    public UserProfileData(UserData userData, String email, TimeZone timeZone, String avatarUrl, Map<String, List<String>> mappedCommitters) {
        this.userData = userData;
        this.email = email;
        this.timeZone = timeZone;
        this.avatarUrl = avatarUrl;
        this.mappedCommitters = mappedCommitters;
        this.preferences = new HashMap<String, Object>();
    }

    public void setPreferences(int changesetsPerPage, int ideConnectorPort, int maxFilesPerChangeset, int tabwidth, boolean enableIde, boolean htmlEmailFormat, boolean nightlyWatchMode, int context, String uploadType, String uploadMethod, String uploadCharset) {
        this.preferences.put("tabWidth", tabwidth);
        this.preferences.put("watchMode", nightlyWatchMode ? "nightly" : "instant");
        this.preferences.put("emailFormat", htmlEmailFormat ? "html" : "plainText");
        this.preferences.put("changesetsPerPage", changesetsPerPage);
        this.preferences.put("maxFilesPerChangeset", maxFilesPerChangeset);
        this.preferences.put("ideConnectorPort", ideConnectorPort);
        this.preferences.put("enableIde", enableIde);
        this.preferences.put("context", context);
        this.preferences.put("uploadtype", uploadType);
        this.preferences.put("uploadmethod", uploadMethod);
        this.preferences.put("uploadcharset", uploadCharset);
    }

    public String getEmail() {
        return this.email;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public Map<String, List<String>> getMappedCommitters() {
        return this.mappedCommitters;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Map<String, Object> getPreferences() {
        return this.preferences;
    }

    public static interface PREFERENCE_VALUES {
        public static final String WATCH_MODE_NIGHTLY = "nightly";
        public static final String WATCH_MODE_INSTANT = "instant";
        public static final String EMAIL_FORMAT_HTML = "html";
        public static final String EMAIL_FORMAT_TEXT = "plainText";
    }

    public static interface PREFERENCE_KEYS {
        public static final String TAB_WIDTH = "tabWidth";
        public static final String WATCH_MODE = "watchMode";
        public static final String EMAIL_FORMAT = "emailFormat";
        public static final String CHANGESETS_PER_PAGE = "changesetsPerPage";
        public static final String MAX_FILES_PER_CHANGESET = "maxFilesPerChangeset";
        public static final String IDE_CONNECTOR_PORT = "ideConnectorPort";
        public static final String ENABLE_IDE = "enableIde";
        public static final String CONTEXT = "context";
        public static final String UPLOAD_TYPE = "uploadtype";
        public static final String UPLOAD_METHOD = "uploadmethod";
        public static final String UPLOAD_CHARSET = "uploadcharset";
    }
}

