/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

public abstract class ContentTooLargeException
extends RuntimeException {
    private final String REVIEW_LIMITS_HELP_PATH = "https://confluence.atlassian.com/display/CRUCIBLE/Creating+a+review#Creatingareview-revisionLimit";

    protected ContentTooLargeException(String message) {
        super(message);
    }

    protected abstract int getLimitSize();

    public String getMessageHtml() {
        return "You cannot perform this action because reviews are limited to " + this.getLimitSize() + " file revisions in Crucible. Each modified file in a review is two revisions -- the revision before the commit and the revision after -- so the maximum number of changed files in a review is " + this.getLimitSize() / 2 + "<br />" + "<a href=\"" + "https://confluence.atlassian.com/display/CRUCIBLE/Creating+a+review#Creatingareview-revisionLimit" + "\">Learn more about Crucible limits.</a>";
    }
}

