/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.services.SearchCriteriaJunctionType;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;

public class ProjectSearchCriteria {
    public final SearchCriteriaJunctionType searchCriteriaJunctionType;
    public final SearchCriteriaType searchCriteriaType;
    public String name;
    public String key;
    public String defaultRepositoryName;
    public String permissionSchemeName;

    private ProjectSearchCriteria(SearchCriteriaJunctionType searchCriteriaJunctionType, SearchCriteriaType searchCriteriaType) {
        this.searchCriteriaJunctionType = searchCriteriaJunctionType;
        this.searchCriteriaType = searchCriteriaType;
    }

    public static ProjectSearchCriteria create(SearchCriteriaJunctionType searchCriteriaJunctionType, SearchCriteriaType searchCriteriaType) {
        return new ProjectSearchCriteria(searchCriteriaJunctionType, searchCriteriaType);
    }

    public static ProjectSearchCriteria create(SearchCriteriaType searchCriteriaType) {
        return ProjectSearchCriteria.create(SearchCriteriaJunctionType.OR, searchCriteriaType);
    }

    public ProjectSearchCriteria all() {
        this.name = null;
        this.key = null;
        this.defaultRepositoryName = null;
        this.permissionSchemeName = null;
        return this;
    }

    public ProjectSearchCriteria name(String name) {
        this.name = name;
        return this;
    }

    public ProjectSearchCriteria key(String key) {
        this.key = key;
        return this;
    }

    public ProjectSearchCriteria defaultRepositoryName(String defaultRepositoryName) {
        this.defaultRepositoryName = defaultRepositoryName;
        return this;
    }

    public ProjectSearchCriteria permissionSchemeName(String permissionSchemeName) {
        this.permissionSchemeName = permissionSchemeName;
        return this;
    }

    public Predicate<ProjectData> filterPredicate() {
        return projectData -> {
            ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
            if (this.key != null) {
                predicatesBuilder.add(v -> SearchCriteriaType.filter(this.searchCriteriaType, this.key, projectData.getKey()));
            }
            if (this.name != null) {
                predicatesBuilder.add(v -> SearchCriteriaType.filter(this.searchCriteriaType, this.name, projectData.getName()));
            }
            if (this.defaultRepositoryName != null) {
                predicatesBuilder.add(v -> SearchCriteriaType.filter(this.searchCriteriaType, this.defaultRepositoryName, projectData.getDefaultRepositoryName()));
            }
            if (this.permissionSchemeName != null) {
                predicatesBuilder.add(v -> SearchCriteriaType.filter(this.searchCriteriaType, this.permissionSchemeName, projectData.getPermissionSchemeName()));
            }
            ImmutableList predicates = predicatesBuilder.build();
            return predicates.stream().map(p -> p.apply(null)).reduce(this.searchCriteriaJunctionType.logicalOperator).orElse(true);
        };
    }
}

