/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.PolledUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.data.UpdateOptions;
import com.google.common.base.Objects;

public class DefaultUpdateOptions
extends UpdateOptions {
    private final CvsUpdateOptions cvsUpdateOptions;
    private final PolledUpdateOptions polledUpdateOptions;
    public static final DefaultUpdateOptions DEFAULT = new DefaultUpdateOptions(CvsUpdateOptions.DEFAULT, PolledUpdateOptions.DEFAULT);

    public DefaultUpdateOptions(CvsUpdateOptions cvsUpdateOptions, PolledUpdateOptions polledUpdateOptions) {
        this.cvsUpdateOptions = cvsUpdateOptions;
        this.polledUpdateOptions = polledUpdateOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultUpdateOptions)) {
            return false;
        }
        DefaultUpdateOptions that = (DefaultUpdateOptions)o;
        return Objects.equal((Object)this.cvsUpdateOptions, (Object)that.cvsUpdateOptions) && Objects.equal((Object)this.polledUpdateOptions, (Object)that.polledUpdateOptions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cvsUpdateOptions, this.polledUpdateOptions});
    }

    public UpdateOptions forRepoType(RepositoryData.Type type) {
        switch (type) {
            case CVS: {
                return this.cvsUpdateOptions;
            }
        }
        return this.polledUpdateOptions;
    }

    public CvsUpdateOptions getCvsUpdateOptions() {
        return this.cvsUpdateOptions;
    }

    public PolledUpdateOptions getPolledUpdateOptions() {
        return this.polledUpdateOptions;
    }
}

