/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.util.FieldValidator;
import java.nio.charset.Charset;

public class P4RepositoryData
extends RepositoryData {
    private String server;
    private String path;
    private String username;
    private String password;
    private Integer blockSize;
    private Boolean caseSensitive;
    private Boolean disableMutli;
    private Charset charset;
    private String commandTimeout;
    private Float connectionsPerSecond;
    private Integer fileLogLimit;
    private Boolean initialImport;
    private Integer port;
    private Boolean skipLabels;
    private Long startRevision;
    private Boolean unicode;

    @Deprecated
    public P4RepositoryData(String name, String server, String path) {
        this(name, name, server, path);
    }

    public P4RepositoryData(String name, String displayName, String server, String path) {
        super(name, displayName);
        this.setServer(server);
        this.setPath(path);
    }

    @Override
    public RepositoryData.Type getType() {
        return RepositoryData.Type.PERFORCE;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        if (server.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("server must not be blank, but was '%s'.", server));
        }
        this.server = server;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("path must not be blank, but was '%s'; you must specify at least the depot.", path));
        }
        this.path = path;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        FieldValidator.INSTANCE.positive("blockSize", blockSize);
        this.blockSize = blockSize;
    }

    public Boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Boolean isDisableMutli() {
        return this.disableMutli;
    }

    public void setDisableMutli(Boolean disableMutli) {
        this.disableMutli = disableMutli;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setCommandTimeout(String commandTimeout) {
        FieldValidator.INSTANCE.validTimeString("commandTimeout", commandTimeout);
        this.commandTimeout = commandTimeout;
    }

    public Float getConnectionsPerSecond() {
        return this.connectionsPerSecond;
    }

    public void setConnectionsPerSecond(Float connectionsPerSecond) {
        FieldValidator.INSTANCE.positive("connectionsPerSecond", connectionsPerSecond);
        this.connectionsPerSecond = connectionsPerSecond;
    }

    public Integer getFileLogLimit() {
        return this.fileLogLimit;
    }

    public void setFileLogLimit(Integer fileLogLimit) {
        FieldValidator.INSTANCE.positive("fileLogLimit", fileLogLimit);
        this.fileLogLimit = fileLogLimit;
    }

    public Boolean isInitialImport() {
        return this.initialImport;
    }

    public void setInitialImport(Boolean initialImport) {
        this.initialImport = initialImport;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        FieldValidator.INSTANCE.positive("port", port);
        this.port = port;
    }

    public Boolean isSkipLabels() {
        return this.skipLabels;
    }

    public void setSkipLabels(Boolean skipLabels) {
        this.skipLabels = skipLabels;
    }

    public Long getStartRevision() {
        return this.startRevision;
    }

    public void setStartRevision(Long startRevision) {
        FieldValidator.INSTANCE.positive("startRevision", startRevision);
        this.startRevision = startRevision;
    }

    public Boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(Boolean unicode) {
        this.unicode = unicode;
    }

    @Override
    public String getLocationDescription() {
        return this.getServer() + (this.getPort() == null ? "" : ":" + this.getPort()) + this.getPath();
    }
}

