/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.ManagedRepositoriesNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class RepositoryData {
    public static final String NAME_REGEX_PATTERN = "[a-zA-Z0-9\\-_\\.]{1,100}";
    public static final Pattern NAME_REGEX = Pattern.compile("^[a-zA-Z0-9\\-_\\.]{1,100}$");
    public static final Pattern TIME_INTERVAL_REGEX = Pattern.compile("^[0-9]+ *(s|second|seconds|mi|minute|minutes|h|hour|hours|d|day|days|w|week|weeks|mo|month|months|y|year|years)$");
    private String name;
    private String displayName;
    private String description;
    private boolean storeDiff = true;
    private Boolean enabled;

    @Deprecated
    public RepositoryData(String name) {
        this(name, name);
    }

    public RepositoryData(String name, String displayName) {
        this.setName(name);
        this.setDisplayName(displayName);
    }

    public abstract Type getType();

    public String getName() {
        return this.name;
    }

    public boolean isObsolete() {
        return false;
    }

    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (!NAME_REGEX.matcher(name).find()) {
            throw new IllegalArgumentException(String.format("name '%s' doesn't match regex '%s'", name, NAME_REGEX.pattern()));
        }
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        if (displayName == null) {
            throw new NullPointerException("Display name must not be null");
        }
        if (!NAME_REGEX.matcher(displayName).find()) {
            throw new IllegalArgumentException(String.format("Display name '%s' doesn't match regex '%s'", displayName, NAME_REGEX.pattern()));
        }
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isStoreDiff() {
        return this.storeDiff;
    }

    public void setStoreDiff(boolean storeDiff) {
        this.storeDiff = storeDiff;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Deprecated
    public boolean isManaged() {
        return false;
    }

    @Deprecated
    public void setManaged(boolean managed) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    @Deprecated
    public String getParent() {
        return null;
    }

    @Deprecated
    public void setParent(String parent) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    public abstract String getLocationDescription();

    public String toString() {
        return String.format("RepositoryData{name='%s', displayName='%s', description='%s', storeDiff=%s, enabled=%s, type='%s'}", new Object[]{this.name, this.displayName, this.description, this.storeDiff, this.enabled, this.getType()});
    }

    public static enum Type {
        CVS("cvs"){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visitCvs();
            }
        }
        ,
        GIT("git"){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visitGit();
            }
        }
        ,
        PERFORCE("p4"){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visitP4();
            }
        }
        ,
        SUBVERSION("svn"){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visitSvn();
            }
        }
        ,
        CLEARCASE("clearcase"){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visitClearcase();
            }
        }
        ,
        HG("hg"){

            @Override
            public <T> T visit(Visitor<T> visitor) {
                return visitor.visitHg();
            }
        };

        private static Map<String, Type> typeByName;
        public final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type fromName(String name) {
            return typeByName.get(name);
        }

        public abstract <T> T visit(Visitor<T> var1);

        static {
            typeByName = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                typeByName.put(type.name, type);
            }
        }

        public static interface Visitor<T> {
            public T visitCvs();

            public T visitSvn();

            public T visitGit();

            public T visitP4();

            public T visitClearcase();

            public T visitHg();
        }
    }
}

