/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.util.FieldValidator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;

public class SvnRepositoryData
extends RepositoryData {
    private String url;
    private String path;
    private String username;
    private String password;
    private Integer blockSize;
    private String commandTimeout;
    private Float connectionsPerSecond;
    private Charset charset;
    private String accessCode;
    private Long startRevision;
    private ImportMode initialImport;
    private Boolean followBase;
    private Boolean usingInbuiltSymbolicRules = false;
    private Collection<SymbolicRule> trunks = new ArrayList<SymbolicRule>();
    private Collection<SymbolicRule> branches = new ArrayList<SymbolicRule>();
    private Collection<SymbolicRule> tags = new ArrayList<SymbolicRule>();

    @Deprecated
    public SvnRepositoryData(String name, String url) {
        this(name, name, url);
    }

    public SvnRepositoryData(String name, String displayName, String url) {
        super(name, displayName);
        this.setUrl(url);
    }

    @Override
    public RepositoryData.Type getType() {
        return RepositoryData.Type.SUBVERSION;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        FieldValidator.INSTANCE.notBlank("url", url);
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        FieldValidator.INSTANCE.positive("blockSize", blockSize);
        this.blockSize = blockSize;
    }

    public String getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setCommandTimeout(String commandTimeout) {
        FieldValidator.INSTANCE.validTimeString("commandTimeout", commandTimeout);
        this.commandTimeout = commandTimeout;
    }

    public Float getConnectionsPerSecond() {
        return this.connectionsPerSecond;
    }

    public void setConnectionsPerSecond(Float connectionsPerSecond) {
        FieldValidator.INSTANCE.positive("connectionsPerSecond", connectionsPerSecond);
        this.connectionsPerSecond = connectionsPerSecond;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public Long getStartRevision() {
        return this.startRevision;
    }

    public void setStartRevision(Long startRevision) {
        FieldValidator.INSTANCE.nonNegative("startRevision", startRevision);
        this.startRevision = startRevision;
    }

    public ImportMode getInitialImport() {
        return this.initialImport;
    }

    public void setInitialImport(ImportMode initialImport) {
        this.initialImport = initialImport;
    }

    public Boolean isFollowBase() {
        return this.followBase;
    }

    public void setFollowBase(Boolean followBase) {
        this.followBase = followBase;
    }

    public Boolean isUsingInbuiltSymbolicRules() {
        return this.usingInbuiltSymbolicRules;
    }

    public void setUsingInbuiltSymbolicRules(Boolean useInbuilt) {
        this.usingInbuiltSymbolicRules = useInbuilt;
    }

    public Collection<SymbolicRule> getTrunks() {
        return new ArrayList<SymbolicRule>(this.trunks);
    }

    public void setTrunks(Collection<SymbolicRule> trunks) {
        this.trunks = new ArrayList<SymbolicRule>(trunks);
    }

    public Collection<SymbolicRule> getBranches() {
        return new ArrayList<SymbolicRule>(this.branches);
    }

    public void setBranches(Collection<SymbolicRule> branches) {
        this.branches = new ArrayList<SymbolicRule>(branches);
    }

    public Collection<SymbolicRule> getTags() {
        return new ArrayList<SymbolicRule>(this.tags);
    }

    public void setTags(Collection<SymbolicRule> tags) {
        this.tags = new ArrayList<SymbolicRule>(tags);
    }

    @Override
    public String getLocationDescription() {
        String url = this.getUrl();
        String path = this.getPath();
        if (url.length() == 0) {
            return path;
        }
        if (path.length() == 0) {
            return url;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return url + "/" + path;
    }

    public static class SymbolicRule {
        private String regex;
        private String name;
        private String logicalPathPrefix;

        public SymbolicRule(String regex, String name, String logicalPathPrefix) {
            this.regex = regex;
            this.name = name;
            this.logicalPathPrefix = logicalPathPrefix;
        }

        public SymbolicRule(SymbolicRule other) {
            this(other.getRegex(), other.getName(), other.getLogicalPathPrefix());
        }

        public String getRegex() {
            return this.regex;
        }

        public SymbolicRule setRegex(String regex) {
            this.regex = regex;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public SymbolicRule setName(String name) {
            this.name = name;
            return this;
        }

        public String getLogicalPathPrefix() {
            return this.logicalPathPrefix;
        }

        public SymbolicRule setLogicalPathPrefix(String logicalPathPrefix) {
            this.logicalPathPrefix = logicalPathPrefix;
            return this;
        }
    }
}

