/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.data;

import com.atlassian.crucible.spi.data.UserData;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;

public class NotificationData {
    private final UserData actioner;
    private final Set<UserData> recipients;
    private final String groupType;
    private final String subject;
    private final String htmlBody;
    private final String textBody;

    private NotificationData() {
        this(null, null, null, null, null, null);
    }

    NotificationData(UserData actioner, Set<UserData> recipients, String groupType, String subject, String htmlBody, String textBody) {
        this.actioner = actioner;
        this.recipients = recipients;
        this.groupType = groupType;
        this.subject = subject;
        this.htmlBody = htmlBody;
        this.textBody = textBody;
    }

    public UserData getActioner() {
        return this.actioner;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public String getTextBody() {
        return this.textBody;
    }

    public Set<UserData> getRecipients() {
        return this.recipients;
    }

    public static Builder builder() {
        return new Builder();
    }

    @XmlTransient
    public static class Builder {
        private UserData actioner;
        private Set<UserData> recipients = new LinkedHashSet<UserData>();
        private String groupType;
        private String subject;
        private String htmlBody;
        private String textBody;

        public Builder setActioner(UserData actioner) {
            this.actioner = actioner;
            return this;
        }

        public Builder setRecipients(Set<UserData> recipients) {
            this.recipients = recipients;
            return this;
        }

        public Builder setGroupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder setTextBody(String textBody) {
            this.textBody = textBody;
            return this;
        }

        public NotificationData build() {
            return new NotificationData(this.actioner, this.recipients, this.groupType, this.subject, this.htmlBody, this.textBody);
        }
    }
}

