/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.util;

import com.atlassian.fisheye.spi.admin.data.RepositoryData;

public enum FieldValidator {
    INSTANCE;


    public void notBlank(String fieldname, String value) {
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("%s must not blank, but was '%s'", fieldname, value));
        }
    }

    public void positive(String fieldname, Integer value) {
        if (value != null && value < 1) {
            throw new IllegalArgumentException(String.format("%s must be positive, instead is %d.", fieldname, value));
        }
    }

    public void positive(String fieldname, Float value) {
        if (value != null && value.compareTo(Float.valueOf(0.0f)) <= 0) {
            throw new IllegalArgumentException(String.format("%s must be positive, instead is %f.", fieldname, value));
        }
    }

    public void positive(String fieldname, Long value) {
        if (value != null && value < 1L) {
            throw new IllegalArgumentException(String.format("%s must be positive, instead is %s.", fieldname, value));
        }
    }

    public void nonNegative(String fieldname, Long value) {
        if (value != null && value < 0L) {
            throw new IllegalArgumentException(String.format("%s must be non-negative, instead is %s.", fieldname, value));
        }
    }

    public void validTimeString(String fieldname, String timeString) {
        if (timeString != null && !RepositoryData.TIME_INTERVAL_REGEX.matcher(timeString).find()) {
            throw new IllegalArgumentException(String.format("timeString '%s' for %s is not valid", timeString, fieldname));
        }
    }
}

