/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

public interface Principal {
    public String getUserName();

    public String getDisplayName();

    public static class SuperUser
    implements Principal {
        public static final SuperUser INSTANCE = new SuperUser();

        public static boolean isSuperUser(Principal principal) {
            return principal == INSTANCE;
        }

        @Override
        public String getUserName() {
            return null;
        }

        @Override
        public String getDisplayName() {
            return "root";
        }

        public boolean equals(Object o) {
            return o == INSTANCE;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class Anonymous
    implements Principal {
        public static final Anonymous ANON = new Anonymous();
        private static final String NAME = "anonymous";

        private Anonymous() {
        }

        @Override
        public String getUserName() {
            return NAME;
        }

        @Override
        public String getDisplayName() {
            return "Guest User";
        }

        public static boolean isAnon(Principal p) {
            return p == null || p == ANON;
        }

        public boolean equals(Object o) {
            return o == ANON;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

