/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.factory;

import com.atlassian.jira.compatibility.factory.BridgeBeanFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class OptionalBridgeBeanFactory<T>
extends BridgeBeanFactory<T> {
    protected OptionalBridgeBeanFactory(Class<T> clazz) {
        super(clazz);
    }

    protected abstract T getBean();

    protected abstract boolean isBeanSupported();

    protected T getBeanWhenUnsupported() {
        Object newProxyInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getObjectType()}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("isBridgeActive")) {
                    return false;
                }
                throw new UnsupportedOperationException();
            }
        });
        return this.getObjectType().cast(newProxyInstance);
    }

    @Override
    public Object getObject() throws Exception {
        if (this.isBeanSupported()) {
            return this.getBean();
        }
        return this.getBeanWhenUnsupported();
    }
}

