/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;

@Internal
final class PropertiesProcessor {
    private static Pattern PASSWORD = Pattern.compile("password", 2);
    private final Map<String, String> properties;

    PropertiesProcessor(Properties properties) {
        Assertions.notNull("properties", properties);
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            props.put(Objects.toString(entry.getKey()), Objects.toString(entry.getValue()));
        }
        this.properties = Collections.unmodifiableMap(props);
    }

    private PropertiesProcessor(Map<String, String> properties) {
        this.properties = properties;
    }

    PropertiesProcessor sanitise(Pattern from, String to) {
        LinkedHashMap<String, String> clone = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (from.matcher(key).find()) {
                clone.put(key, to);
                continue;
            }
            clone.put(key, entry.getValue());
        }
        return new PropertiesProcessor(Collections.unmodifiableMap(clone));
    }

    PropertiesProcessor sort() {
        TreeMap<String, String> props = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        props.putAll(this.properties);
        return new PropertiesProcessor(Collections.unmodifiableMap(props));
    }

    PropertiesProcessor sanitisePassword() {
        return this.sanitise(PASSWORD, "****");
    }

    Map<String, String> toMap() {
        return this.properties;
    }
}

