/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.dbc.Assertions;

public interface EncodingConfiguration {
    public String getEncoding();

    public static class Static
    implements EncodingConfiguration {
        private final String encoding;

        public Static(String encoding) {
            Assertions.notBlank("encoding", encoding);
            this.encoding = encoding;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }
    }

    public static class PropertiesAdaptor
    implements EncodingConfiguration {
        private final ApplicationProperties applicationProperties;

        public PropertiesAdaptor(ApplicationProperties applicationProperties) {
            Assertions.notNull("applicationProperties", applicationProperties);
            this.applicationProperties = applicationProperties;
        }

        @Override
        public String getEncoding() {
            return this.applicationProperties.getEncoding();
        }
    }
}

