/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.priority.Priority;
import java.util.Objects;

@Internal
public class PriorityMovedEvent
extends AbstractEvent {
    private final Priority priority;
    private final Long from;
    private final Long to;

    public PriorityMovedEvent(Priority priority, Long from, Long to) {
        this.priority = priority;
        this.from = from;
        this.to = to;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Long getFrom() {
        return this.from;
    }

    public Long getTo() {
        return this.to;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PriorityMovedEvent that = (PriorityMovedEvent)o;
        return Objects.equals(this.priority, that.priority) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.priority, this.from, this.to);
    }

    public String toString() {
        return "PriorityMovedEvent{priority=" + this.priority + ", from=" + this.from + ", to=" + this.to + '}';
    }
}

