/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AttachmentRenderedJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String filename;
    @JsonProperty
    private UserJsonBean author;
    @JsonProperty
    private String created;
    @JsonProperty
    private String size;
    @JsonProperty
    private String mimeType;
    @JsonProperty
    private String content;
    @JsonProperty
    private String thumbnail;

    public String getSelf() {
        return this.self;
    }

    public String getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public String getCreated() {
        return this.created;
    }

    public String getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getContent() {
        return this.content;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    @Deprecated
    public static Collection<AttachmentRenderedJsonBean> shortBeans(Collection<Attachment> attachments, JiraBaseUrls urls, ThumbnailManager thumbnailManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        return AttachmentRenderedJsonBean.shortBeans(attachments, urls, thumbnailManager, dateTimeFormatterFactory, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static Collection<AttachmentRenderedJsonBean> shortBeans(Collection<Attachment> attachments, JiraBaseUrls urls, ThumbnailManager thumbnailManager, DateTimeFormatterFactory dateTimeFormatterFactory, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        ArrayList result = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Attachment from : attachments) {
            result.add(AttachmentRenderedJsonBean.shortBean(from, urls, thumbnailManager, dateTimeFormatterFactory, loggedInUser, emailFormatter));
        }
        return result;
    }

    @Deprecated
    public static AttachmentRenderedJsonBean shortBean(Attachment attachment, JiraBaseUrls urls, ThumbnailManager thumbnailManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        return AttachmentRenderedJsonBean.shortBean(attachment, urls, thumbnailManager, dateTimeFormatterFactory, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static AttachmentRenderedJsonBean shortBean(Attachment attachment, JiraBaseUrls urls, ThumbnailManager thumbnailManager, DateTimeFormatterFactory dateTimeFormatterFactory, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        AttachmentRenderedJsonBean bean;
        if (attachment == null) {
            return null;
        }
        try {
            bean = new AttachmentRenderedJsonBean();
            bean.self = urls.restApi2BaseUrl() + "attachment/" + JiraUrlCodec.encode(attachment.getId().toString());
            bean.id = attachment.getId().toString();
            bean.filename = attachment.getFilename();
            bean.size = FileSize.format((Long)attachment.getFilesize());
            bean.mimeType = attachment.getMimetype();
            bean.author = ComponentAccessor.getComponent(UserBeanFactory.class).createBean(attachment.getAuthorObject(), loggedInUser, urls, emailFormatter, ComponentAccessor.getComponent(TimeZoneManager.class));
            bean.content = attachment.getFilename();
            bean.created = attachment.getCreated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(attachment.getCreated());
            String encodedFilename = URLEncoder.encode(attachment.getFilename(), "UTF-8");
            bean.content = String.format("%s/secure/attachment/%s/%s", urls.baseUrl(), attachment.getId(), encodedFilename);
            ThumbnailedImage thumbnail = thumbnailManager.toThumbnailedImage(thumbnailManager.getThumbnail(attachment.getIssueObject(), attachment));
            if (thumbnail != null) {
                bean.thumbnail = thumbnail.getImageURL();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding file name", e);
        }
        return bean;
    }
}

