/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;

public class SecurityLevelJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String name;

    public SecurityLevelJsonBean(String self, String id, String description, String name) {
        this.self = self;
        this.id = id;
        this.description = description;
        this.name = name;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static Collection<SecurityLevelJsonBean> shortBeans(Collection<IssueSecurityLevel> securitylevels, JiraBaseUrls urls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)securitylevels.size());
        for (IssueSecurityLevel from : securitylevels) {
            result.add(SecurityLevelJsonBean.shortBean(from, urls));
        }
        return result;
    }

    public static SecurityLevelJsonBean shortBean(IssueSecurityLevel securityLevel, JiraBaseUrls urls) {
        if (securityLevel == null) {
            return null;
        }
        return new SecurityLevelJsonBean(SecurityLevelJsonBean.getSelf(urls.restApi2BaseUrl(), JiraUrlCodec.encode(securityLevel.getId().toString())), securityLevel.getId().toString(), securityLevel.getDescription(), securityLevel.getName());
    }

    public static String getSelf(String baseURL, String encodedSecurityLevelId) {
        return baseURL + "securitylevel/" + encodedSecurityLevelId;
    }
}

