/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(LocalDateIndexer.class);
    private final boolean skipIndexingNull;

    public LocalDateIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, boolean skipIndexingNull) {
        super(fieldVisibilityManager, customField);
        this.skipIndexingNull = skipIndexingNull;
    }

    public LocalDateIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        this(fieldVisibilityManager, customField, false);
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    @Override
    public Boolean skipsIndexingNull() {
        return this.skipIndexingNull;
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        String sortDateFieldName = "sort_" + this.getDocumentFieldId();
        if (value instanceof Date) {
            Date date = (Date)value;
            try {
                LocalDate localDate = LocalDateFactory.from(date);
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), localDate.getEpochDays()));
                if (searchable) {
                    doc.add((IndexableField)new LongPoint(this.getDocumentFieldId(), new long[]{localDate.getEpochDays()}));
                    doc.add((IndexableField)new NumericDocValuesField(sortDateFieldName, localDate.getEpochDays()));
                } else {
                    doc.add((IndexableField)new NumericDocValuesField(sortDateFieldName, Long.MAX_VALUE));
                }
            }
            catch (RuntimeException ex) {
                log.warn("Unable to index custom date field '" + this.customField.getName() + "(" + this.customField.getId() + ") with value: " + value);
            }
        }
        if (value == null && !this.skipIndexingNull) {
            doc.add((IndexableField)new NumericDocValuesField(sortDateFieldName, Long.MAX_VALUE));
        }
    }
}

