/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class TextTermEscaper {
    private static final Set<Character> ALLOWED_LUCENE_OPERATORS = ImmutableSet.of((Object)Character.valueOf('+'), (Object)Character.valueOf('-'), (Object)Character.valueOf('&'), (Object)Character.valueOf('|'), (Object)Character.valueOf('!'), (Object)Character.valueOf('('), (Object[])new Character[]{Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"')});
    private static final Set<Character> DISALLOWED_LUCENE_OPERATORS = ImmutableSet.of((Object)Character.valueOf(':'), (Object)Character.valueOf('/'));

    public static String escape(CharSequence input) {
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            Character c = Character.valueOf(input.charAt(i));
            if (DISALLOWED_LUCENE_OPERATORS.contains(c)) {
                escaped.append('\\');
            } else if (c.equals(Character.valueOf('\\'))) {
                Character nextChar;
                Character c2 = nextChar = i + 1 < input.length() ? Character.valueOf(input.charAt(i + 1)) : null;
                if (TextTermEscaper.shouldEscapeBackslash(nextChar)) {
                    escaped.append('\\');
                }
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private static boolean shouldEscapeBackslash(Character charAfterBackslash) {
        return !ALLOWED_LUCENE_OPERATORS.contains(charAfterBackslash);
    }
}

