/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.util.JqlVersionPredicate;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class VersionClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<Version>
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final VersionResolver versionResolver;

    public VersionClauseContextFactory(JqlOperandResolver jqlOperandResolver, VersionResolver versionResolver, PermissionManager permissionManager) {
        super(new VersionIndexInfoResolver(versionResolver), jqlOperandResolver, permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
    }

    @Override
    ClauseContext getContextFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        HashMap specifiedVersions = literals != null ? Maps.newHashMapWithExpectedSize((int)literals.size()) : Maps.newHashMap();
        boolean containsEmpty = false;
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.isEmpty()) {
                    containsEmpty = true;
                    continue;
                }
                List<Long> ids = this.getIds(literal);
                for (Long id : ids) {
                    specifiedVersions.put(id, this.versionResolver.get(id));
                }
            }
        }
        if (!specifiedVersions.isEmpty()) {
            Collection contextVersions = this.isRelationalOperator(operator) ? (Collection)specifiedVersions.values().stream().flatMap(version -> {
                JqlVersionPredicate predicate = new JqlVersionPredicate(operator, (Version)version);
                return this.versionResolver.getAll().stream().filter(predicate::evaluate);
            }).collect(CollectorsUtil.toImmutableList()) : (this.isNegationOperator(operator) ? (Collection)this.versionResolver.getAll().stream().filter(version -> !specifiedVersions.containsKey(version.getId())).collect(CollectorsUtil.toImmutableList()) : specifiedVersions.values());
            HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
            HashSet<Long> checkedProjects = new HashSet<Long>();
            for (Version contextVersion : contextVersions) {
                if (!checkedProjects.add(contextVersion.getProjectId())) continue;
                contexts.addAll(this.getContextsForProject(searcher, contextVersion.getProjectObject()));
            }
            if (containsEmpty) {
                contexts.add(ProjectIssueTypeContextImpl.createGlobalContext());
            }
            return new ClauseContextImpl(contexts);
        }
        return ClauseContextImpl.createGlobalClauseContext();
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator) || OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

