/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.query.operator.Operator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEqualityQueryFactory<T>
extends AbstractOperatorQueryFactory<T>
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractEqualityQueryFactory.class);

    public AbstractEqualityQueryFactory(IndexInfoResolver<T> indexInfoResolver) {
        super(indexInfoResolver);
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.EQUALS.equals((Object)operator)) {
            return this.handleEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_EQUALS.equals((Object)operator)) {
            return this.handleNotEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (log.isDebugEnabled()) {
            log.debug("Create query for single value was called with operator '" + operator.getDisplayString() + "', this only handles '=' and '!='.");
        }
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (Operator.IN.equals((Object)operator)) {
            return this.handleEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (Operator.NOT_IN.equals((Object)operator)) {
            return this.handleNotEquals(fieldName, this.getIndexValues(rawValues));
        }
        if (log.isDebugEnabled()) {
            log.debug("Create query for multiple value was called with operator '" + operator.getDisplayString() + "', this only handles 'in'.");
        }
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    QueryFactoryResult handleNotEquals(String fieldName, List<String> indexValues) {
        if (indexValues == null) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        TermInSetQuery termInSetQuery = this.getTermInSetQuery(fieldName, indexValues);
        if (termInSetQuery.getTermData().size() == 0L) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        boolQuery.add(this.getIsNotEmptyQuery(fieldName), BooleanClause.Occur.FILTER);
        boolQuery.add((Query)termInSetQuery, BooleanClause.Occur.MUST_NOT);
        boolQuery.add(TermQueryFactory.visibilityQuery(fieldName), BooleanClause.Occur.FILTER);
        return new QueryFactoryResult((Query)boolQuery.build(), false);
    }

    QueryFactoryResult handleEquals(String fieldName, List<String> indexValues) {
        if (indexValues == null) {
            return QueryFactoryResult.createFalseResult();
        }
        if (indexValues.size() == 1) {
            String id = indexValues.get(0);
            return id == null ? new QueryFactoryResult(this.getIsEmptyQuery(fieldName)) : new QueryFactoryResult((Query)this.getTermQuery(fieldName, id));
        }
        BooleanQuery.Builder orQuery = new BooleanQuery.Builder();
        TermInSetQuery termInSetQuery = this.getTermInSetQuery(fieldName, indexValues);
        if (termInSetQuery.getTermData().size() > 0L) {
            orQuery.add((Query)termInSetQuery, BooleanClause.Occur.SHOULD);
        }
        if (this.hasEmptyValues(indexValues)) {
            orQuery.add(this.getIsEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)orQuery.build());
    }

    private TermInSetQuery getTermInSetQuery(String fieldName, List<String> indexValues) {
        List bytesRefs = indexValues.stream().filter(Objects::nonNull).map(BytesRef::new).collect(Collectors.toList());
        return new TermInSetQuery(fieldName, bytesRefs);
    }

    private boolean hasEmptyValues(List<String> indexValues) {
        return indexValues.stream().anyMatch(Objects::isNull);
    }

    abstract Query getIsEmptyQuery(String var1);

    abstract Query getIsNotEmptyQuery(String var1);
}

