/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class JqlCustomFieldId {
    private static final Pattern pattern = Pattern.compile("\\s*cf\\s*\\[\\s*(\\d+)\\s*\\]\\s*", 2);
    private final long id;

    public JqlCustomFieldId(long id) {
        Assertions.not("id", id < 0L);
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getJqlName() {
        return JqlCustomFieldId.toString(this.id);
    }

    public String toString() {
        return this.getJqlName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JqlCustomFieldId that = (JqlCustomFieldId)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public static String toString(long id) {
        if (id < 0L) {
            throw new IllegalArgumentException("id should be >= 0");
        }
        return String.format("cf[%d]", id);
    }

    public static boolean isJqlCustomFieldId(String fieldName) {
        return JqlCustomFieldId.parseId(fieldName) >= 0L;
    }

    public static JqlCustomFieldId parseJqlCustomFieldId(String fieldName) {
        long fieldId = JqlCustomFieldId.parseId(fieldName);
        if (fieldId >= 0L) {
            return new JqlCustomFieldId(fieldId);
        }
        return null;
    }

    public static long parseId(String fieldName) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return -1L;
        }
        Matcher matcher = pattern.matcher(fieldName.trim());
        if (matcher.matches()) {
            try {
                long longId = Long.parseLong(matcher.group(1));
                if (longId >= 0L) {
                    return longId;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Long.MIN_VALUE;
    }
}

