/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.permission.PermissionHolderType;
import com.google.common.base.Strings;
import io.atlassian.fugue.Option;
import javax.annotation.Nullable;

@PublicApi
public enum JiraPermissionHolderType implements PermissionHolderType
{
    GROUP("group", true),
    ANYONE("group", false),
    USER("user", true),
    PROJECT_ROLE("projectrole", true),
    REPORTER("reporter", false),
    PROJECT_LEAD("lead", false),
    ASSIGNEE("assignee", false),
    USER_CUSTOM_FIELD("userCF", true),
    GROUP_CUSTOM_FIELD("groupCF", true),
    REPORTER_WITH_CREATE_PERMISSION("reportercreate", false),
    ASSIGNEE_WITH_ASSIGNABLE_PERMISSION("assigneeassignable", false),
    APPLICATION_ROLE("applicationRole", true);

    private final String key;
    private final boolean requiresParameter;

    private JiraPermissionHolderType(String key, boolean requiresParameter) {
        this.key = key;
        this.requiresParameter = requiresParameter;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean requiresParameter() {
        return this.requiresParameter;
    }

    public static Option<JiraPermissionHolderType> fromKey(String key, @Nullable String parameter) {
        boolean isParameterDefined = !Strings.isNullOrEmpty((String)parameter);
        for (JiraPermissionHolderType type : JiraPermissionHolderType.values()) {
            if (!type.getKey().equals(key) || isParameterDefined != type.requiresParameter()) continue;
            return Option.some((Object)type);
        }
        return Option.none();
    }
}

