/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.util.NamedWithDescription;
import com.atlassian.jira.util.NamedWithId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Scheme
implements NamedWithDescription,
NamedWithId {
    private Long id;
    private String type;
    private String name;
    private String description;
    private ArrayList<SchemeEntity> entities;

    public Scheme() {
        this(null, null, null, null, Collections.emptyList());
    }

    public Scheme(String type, String name) {
        this(null, type, name, null, Collections.emptyList());
    }

    public Scheme(Long id, String type, String name, Collection<SchemeEntity> entities) {
        this(id, type, name, null, entities);
    }

    public Scheme(Long id, String type, String name, String description, Collection<SchemeEntity> entities) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.description = description;
        this.entities = new ArrayList<SchemeEntity>(entities);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<SchemeEntity> getEntities() {
        if (this.entities == null) {
            return Collections.emptyList();
        }
        return this.entities;
    }

    public void setEntities(Collection<SchemeEntity> entities) {
        this.entities = new ArrayList<SchemeEntity>(entities);
    }

    public void addEntity(SchemeEntity entity) {
        this.entities.add(entity);
    }

    public void removeEntity(SchemeEntity entity) {
        this.entities.remove(entity);
    }

    public boolean containsSameEntities(Scheme other) {
        return this.getEntities().size() == other.getEntities().size() && this.getEntities().containsAll(other.getEntities());
    }

    public Scheme cloneScheme() {
        return new Scheme(null, this.type, "Clone of " + this.name, new ArrayList<SchemeEntity>(this.entities));
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<SchemeEntity> getEntitiesByType(Object typeId) {
        ArrayList matchedEntities;
        ArrayList arrayList = matchedEntities = this.entities != null ? Lists.newArrayListWithCapacity((int)this.entities.size()) : Lists.newArrayList();
        if (this.entities != null) {
            for (SchemeEntity schemeEntity : this.entities) {
                if (!schemeEntity.getEntityTypeId().equals(typeId)) continue;
                matchedEntities.add(schemeEntity);
            }
        }
        return matchedEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scheme that = (Scheme)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.entities, that.entities);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.type, this.name, this.description, this.entities});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("name", (Object)this.name).add("description", (Object)this.description).add("entities", (Object)("[" + MoreObjects.firstNonNull((Object)this.entities.size(), Collections.emptyList()) + "]")).toString();
    }
}

