/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

public class SchemeEntity
implements Comparable {
    private Long id;
    private String type;
    private String parameter;
    private Object entityTypeId;
    private Object templateId;
    private Long schemeId;

    public SchemeEntity(String type, Object entityTypeId) {
        if (type == null) {
            throw new IllegalArgumentException("Type passed can NOT be null");
        }
        if (entityTypeId == null) {
            throw new IllegalArgumentException("EntityTypeId passed can NOT be null");
        }
        this.type = type;
        this.entityTypeId = entityTypeId;
    }

    public SchemeEntity(String type, String parameter, Object entityTypeId) {
        this(type, entityTypeId);
        this.parameter = parameter;
    }

    public SchemeEntity(String type, String parameter, Object entityTypeId, Object templateId) {
        this(type, parameter, entityTypeId);
        this.templateId = templateId;
    }

    public SchemeEntity(Long id, String type, String parameter, Object entityTypeId, Object templateId, Long schemeId) {
        this(type, parameter, entityTypeId);
        this.templateId = templateId;
        this.id = id;
        this.schemeId = schemeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Object getEntityTypeId() {
        return this.entityTypeId;
    }

    public void setEntityTypeId(Object entityTypeId) {
        this.entityTypeId = entityTypeId;
    }

    public Object getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Object templateId) {
        this.templateId = templateId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemeEntity)) {
            return false;
        }
        SchemeEntity schemeEntity = (SchemeEntity)o;
        if (this.entityTypeId != null ? !this.entityTypeId.equals(schemeEntity.entityTypeId) : schemeEntity.entityTypeId != null) {
            return false;
        }
        if (this.parameter != null ? !this.parameter.equals(schemeEntity.parameter) : schemeEntity.parameter != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(schemeEntity.type) : schemeEntity.type != null) {
            return false;
        }
        if (this.templateId != null ? !this.templateId.equals(schemeEntity.templateId) : schemeEntity.templateId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(schemeEntity.getId()) : schemeEntity.getId() != null) {
            return false;
        }
        return !(this.schemeId != null ? !this.schemeId.equals(schemeEntity.getSchemeId()) : schemeEntity.getSchemeId() != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 29 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
        result = 29 * result + (this.entityTypeId != null ? this.entityTypeId.hashCode() : 0);
        result = 29 * result + (this.templateId != null ? this.templateId.hashCode() : 0);
        result = 29 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 29 * result + (this.schemeId != null ? this.schemeId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Type = " + this.type + " Parameter = " + this.parameter + " EntityTypeId = " + this.entityTypeId + " TemplateId = " + this.templateId + " Id = " + this.id + " SchemeId = " + this.schemeId;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof SchemeEntity)) {
            return 1;
        }
        SchemeEntity schemeEntity = (SchemeEntity)o;
        if (this.parameter != null && schemeEntity.parameter != null) {
            return this.parameter.compareTo(schemeEntity.parameter);
        }
        return 0;
    }
}

