/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.search;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.search.AuthenticatedUserShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.GlobalShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.type.GroupSharePermission;
import com.atlassian.jira.sharing.type.ProjectSharePermission;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.UserSharePermission;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SharedEntitySearchParametersBuilder {
    private String name = null;
    private String description = null;
    private String user = null;
    private Boolean favourite = null;
    private SharedEntityColumn sortColumn = SharedEntityColumn.NAME;
    private boolean sortOrderAscending = true;
    private ShareTypeSearchParameter shareTypeParameter = null;
    private SharedEntitySearchParameters.TextSearchMode textSearchMode = SharedEntitySearchParameters.TextSearchMode.OR;
    private SharedEntitySearchContext entitySearchContext = SharedEntitySearchContext.USE;

    public SharedEntitySearchParametersBuilder() {
    }

    public SharedEntitySearchParametersBuilder(SharedEntitySearchParameters sharedEntitySearchParameters) {
        Assertions.notNull("sharedEntitySearchParameters", sharedEntitySearchParameters);
        this.setName(sharedEntitySearchParameters.getName());
        this.setDescription(sharedEntitySearchParameters.getDescription());
        this.setFavourite(sharedEntitySearchParameters.getFavourite());
        this.setShareTypeParameter(sharedEntitySearchParameters.getShareTypeParameter());
        this.setSortColumn(sharedEntitySearchParameters.getSortColumn(), sharedEntitySearchParameters.isAscendingSort());
        this.setUserName(sharedEntitySearchParameters.getUserName());
        this.setTextSearchMode(sharedEntitySearchParameters.getTextSearchMode());
    }

    public SharedEntitySearchParametersBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public SharedEntitySearchParametersBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public SharedEntitySearchParametersBuilder setUserName(String user) {
        this.user = user;
        return this;
    }

    public SharedEntitySearchParametersBuilder setFavourite(Boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    public SharedEntitySearchParametersBuilder setSortColumn(@Nullable SharedEntityColumn column, boolean sortOrderAscending) {
        this.sortColumn = column;
        this.sortOrderAscending = sortOrderAscending;
        return this;
    }

    public SharedEntitySearchParametersBuilder setShareTypeParameter(ShareTypeSearchParameter shareTypeParameter) {
        this.shareTypeParameter = shareTypeParameter;
        return this;
    }

    public SharedEntitySearchParametersBuilder setTextSearchMode(SharedEntitySearchParameters.TextSearchMode textSearchMode) {
        this.textSearchMode = textSearchMode;
        return this;
    }

    public SharedEntitySearchParametersBuilder setEntitySearchContext(SharedEntitySearchContext entitySearchContext) {
        this.entitySearchContext = entitySearchContext;
        return this;
    }

    public SharedEntitySearchParametersBuilder setSharePermission(SharePermission permission) {
        this.setShareTypeParameter(this.getShareTypeParameter(permission));
        return this;
    }

    private ShareTypeSearchParameter getShareTypeParameter(SharePermission permission) {
        ShareType.Name type = permission.getType();
        if (ShareType.Name.GLOBAL.equals(type)) {
            return GlobalShareTypeSearchParameter.GLOBAL_PARAMETER;
        }
        if (ShareType.Name.AUTHENTICATED.equals(type)) {
            return AuthenticatedUserShareTypeSearchParameter.AUTHENTICATED_USER_PARAMETER;
        }
        if (ShareType.Name.PROJECT.equals(type)) {
            return new ProjectSharePermission(permission).getSearchParameter();
        }
        if (ShareType.Name.GROUP.equals(type)) {
            return new GroupSharePermission(permission).getSearchParameter();
        }
        if (ShareType.Name.USER.equals(type)) {
            return new UserSharePermission(permission).getSearchParameter();
        }
        throw new UnsupportedOperationException("Cannot create a Search Parameter for: " + type);
    }

    public SharedEntitySearchParameters toSearchParameters() {
        return new SearchParametersImpl(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private static class SearchParametersImpl
    implements SharedEntitySearchParameters {
        private final String name;
        private final String description;
        private final String userName;
        private final SharedEntityColumn sortColumn;
        private final Boolean favourite;
        private final boolean sortAscending;
        private final ShareTypeSearchParameter shareTypeParameter;
        private final SharedEntitySearchParameters.TextSearchMode textSearchMode;
        private final SharedEntitySearchContext entitySearchContext;

        private SearchParametersImpl(SharedEntitySearchParametersBuilder builder) {
            this.name = builder.name;
            this.description = builder.description;
            this.userName = builder.user;
            this.sortColumn = builder.sortColumn;
            this.favourite = builder.favourite;
            this.sortAscending = builder.sortOrderAscending;
            this.shareTypeParameter = builder.shareTypeParameter;
            this.textSearchMode = builder.textSearchMode;
            this.entitySearchContext = builder.entitySearchContext;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }

        @Override
        public Boolean getFavourite() {
            return this.favourite;
        }

        @Override
        public boolean isAscendingSort() {
            return this.sortAscending;
        }

        @Override
        public SharedEntityColumn getSortColumn() {
            return this.sortColumn;
        }

        @Override
        public ShareTypeSearchParameter getShareTypeParameter() {
            return this.shareTypeParameter;
        }

        @Override
        public SharedEntitySearchContext getEntitySearchContext() {
            return this.entitySearchContext;
        }

        @Override
        public SharedEntitySearchParameters.TextSearchMode getTextSearchMode() {
            return this.textSearchMode;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParametersImpl that = (SearchParametersImpl)o;
            if (this.sortAscending != that.sortAscending) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.favourite != null ? !this.favourite.equals(that.favourite) : that.favourite != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.shareTypeParameter != null ? !this.shareTypeParameter.equals(that.shareTypeParameter) : that.shareTypeParameter != null) {
                return false;
            }
            if (this.sortColumn != null ? !this.sortColumn.equals((Object)that.sortColumn) : that.sortColumn != null) {
                return false;
            }
            if (this.textSearchMode != null ? !this.textSearchMode.equals(that.textSearchMode) : that.textSearchMode != null) {
                return false;
            }
            return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
            result = 31 * result + (this.sortColumn != null ? this.sortColumn.hashCode() : 0);
            result = 31 * result + (this.favourite != null ? this.favourite.hashCode() : 0);
            result = 31 * result + (this.sortAscending ? 1 : 0);
            result = 31 * result + (this.shareTypeParameter != null ? this.shareTypeParameter.hashCode() : 0);
            result = 31 * result + (this.textSearchMode != null ? this.textSearchMode.hashCode() : 0);
            return result;
        }
    }
}

