/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.ofbiz;

import com.atlassian.annotations.Internal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;

@Internal
public class GenericValueUtils {
    public static Long[] transformToLongIds(Collection<GenericValue> genericValues) {
        if (genericValues != null) {
            Long[] ids = new Long[genericValues.size()];
            int i = 0;
            for (GenericValue gv : genericValues) {
                ids[i] = gv != null ? gv.getLong("id") : new Long(-1L);
                ++i;
            }
            return ids;
        }
        return null;
    }

    public static List<Long> transformToLongIdsList(Collection<GenericValue> genericValues) {
        if (genericValues == null) {
            return null;
        }
        return Arrays.asList(GenericValueUtils.transformToLongIds(genericValues));
    }

    public static String[] transformToStrings(Collection<GenericValue> genericValues, String fieldName) {
        if (genericValues != null && fieldName != null) {
            String[] strings = new String[genericValues.size()];
            int i = 0;
            for (GenericValue gv : genericValues) {
                strings[i] = gv != null ? gv.getString(fieldName) : "-1";
                ++i;
            }
            return strings;
        }
        return null;
    }

    public static String[] transformToStringIds(Collection<GenericValue> genericValues) {
        if (genericValues != null) {
            String[] ids = new String[genericValues.size()];
            int i = 0;
            for (GenericValue gv : genericValues) {
                ids[i] = gv != null ? gv.getString("id") : "-1";
                ++i;
            }
            return ids;
        }
        return null;
    }

    public static List<String> transformToStringIdsList(Collection<GenericValue> genericValues) {
        if (genericValues == null) {
            return null;
        }
        return Arrays.asList(GenericValueUtils.transformToStringIds(genericValues));
    }

    public static String getCommaSeparatedList(Collection<GenericValue> genericValues, String key) {
        if (genericValues == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("key must be a non-empty String");
        }
        StringBuilder sb = new StringBuilder();
        Iterator<GenericValue> iterator = genericValues.iterator();
        while (iterator.hasNext()) {
            GenericValue gv = iterator.next();
            sb.append(gv.getString(key));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

