/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.order.SearchSort;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueTableLayoutBean {
    private static final Logger log = LoggerFactory.getLogger(IssueTableLayoutBean.class);
    public static final String CELL_NO_LINK = "nolink";
    public static final String CELL_TEXT_ONLY = "textOnly";
    public static final String FULL_LINK = "full_link";
    public static final String DEFAULT_COLUMNS = "--default--";
    public static final String EXCEL_VIEW = "excel_view";
    public static final String NAVIGATOR_VIEW = "navigator_view";
    private final List<ColumnLayoutItem> columns;
    private final Collection<SearchSort> searchSorts;
    private boolean sortingEnabled = true;
    private boolean showHeaderDescription = false;
    private boolean alternateRowColors = true;
    private boolean showTableEditHeader = false;
    private boolean displayHeader = true;
    private boolean displayHeaderPager = true;
    private boolean showExteriorTable = true;
    private boolean subtasksTable = false;
    private String tableCssClass = "grid";
    private Map<String, Object> cellDisplayParams = new HashMap<String, Object>();
    private Long filterId;
    private String actionUrl;
    private boolean showActionColumn = false;

    public IssueTableLayoutBean(List<ColumnLayoutItem> columns) {
        this(columns, null);
    }

    public IssueTableLayoutBean(List<ColumnLayoutItem> columns, Collection<SearchSort> searchSorts) {
        this.columns = columns;
        this.searchSorts = searchSorts;
    }

    public IssueTableLayoutBean(ApplicationUser user, Collection<SearchSort> searchSorts) {
        this(IssueTableLayoutBean.getDefaultColumns(user), searchSorts);
    }

    private static List<ColumnLayoutItem> getDefaultColumns(ApplicationUser user) {
        List<ColumnLayoutItem> columns = Collections.emptyList();
        try {
            ColumnLayout columnLayout = ComponentAccessor.getColumnLayoutManager().getColumnLayout(user);
            columns = columnLayout.getAllVisibleColumnLayoutItems(user);
        }
        catch (Exception e) {
            log.error("Exception whilst getting a users default columns " + e.getMessage(), (Throwable)e);
        }
        return columns;
    }

    public List<ColumnLayoutItem> getColumns() {
        return this.columns;
    }

    public SearchSort getFirstSorter() {
        if (this.searchSorts != null && !this.searchSorts.isEmpty()) {
            return this.searchSorts.iterator().next();
        }
        return null;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public void addCellDisplayParam(String key, Object value) {
        this.cellDisplayParams.put(key, value);
    }

    public Map getCellDisplayParams() {
        return this.cellDisplayParams;
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public void setSortingEnabled(boolean sortingEnabled) {
        this.sortingEnabled = sortingEnabled;
    }

    public boolean isShowHeaderDescription() {
        return this.showHeaderDescription;
    }

    public void setShowHeaderDescription(boolean showHeaderDescription) {
        this.showHeaderDescription = showHeaderDescription;
    }

    public boolean isAlternateRowColors() {
        return this.alternateRowColors;
    }

    public void setAlternateRowColors(boolean alternateRowColors) {
        this.alternateRowColors = alternateRowColors;
    }

    public boolean isShowTableEditHeader() {
        return this.showTableEditHeader;
    }

    public void setShowTableEditHeader(boolean showTableEditHeader) {
        this.showTableEditHeader = showTableEditHeader;
    }

    public void setFilterId(Long filterId) {
        this.filterId = filterId;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public void setDisplayHeader(boolean displayHeader) {
        this.displayHeader = displayHeader;
    }

    public boolean isDisplayHeader() {
        return this.displayHeader;
    }

    public boolean isDisplayHeaderPager() {
        return this.displayHeaderPager;
    }

    public void setDisplayHeaderPager(boolean displayHeaderPager) {
        this.displayHeaderPager = displayHeaderPager;
    }

    public void setSubtasksTable(boolean subtasksTable) {
        this.subtasksTable = subtasksTable;
    }

    public boolean isSubtasksTable() {
        return this.subtasksTable;
    }

    public boolean isShowExteriorTable() {
        return this.showExteriorTable;
    }

    public void setShowExteriorTable(boolean showExteriorTable) {
        this.showExteriorTable = showExteriorTable;
    }

    public String getTableCssClass() {
        return this.tableCssClass;
    }

    public void setTableCssClass(String tableCssClass) {
        this.tableCssClass = tableCssClass;
    }

    public boolean isShowActionColumn() {
        return this.showActionColumn;
    }

    public void setShowActionColumn(boolean showActionColumn) {
        this.showActionColumn = showActionColumn;
    }
}

