/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.order;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Property;
import com.atlassian.query.order.SortOrder;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import java.io.Serializable;

public class SearchSort
implements Serializable {
    private final SortOrder order;
    private final String field;
    private final Option<Property> property;

    public SearchSort(String field) {
        this(field, (SortOrder)null);
    }

    public SearchSort(String field, SortOrder order) {
        this(field, (Option<Property>)Option.none(), order);
    }

    public SearchSort(String field, Option<Property> property, SortOrder order) {
        this.field = Assertions.notBlank("field", field);
        this.order = order;
        this.property = property;
    }

    public SearchSort(String order, String field) {
        this(field, (Option<Property>)Option.none(), SortOrder.parseString(order));
    }

    public SearchSort(SearchSort copy) {
        Assertions.notNull("copy", copy);
        this.field = copy.field;
        this.order = copy.order;
        this.property = copy.property;
    }

    public String getOrder() {
        return this.order == null ? null : this.order.name();
    }

    public SortOrder getSortOrder() {
        return this.order;
    }

    public String getField() {
        return this.field;
    }

    public Option<Property> getProperty() {
        return this.property;
    }

    public boolean isReverse() {
        return this.order == SortOrder.DESC;
    }

    public String toString() {
        final StringBuilder toString = new StringBuilder(this.field);
        this.property.foreach((Effect)new Effect<Property>(){

            public void apply(Property property) {
                toString.append(property.toString());
            }
        });
        if (this.order != null) {
            toString.append(" ").append((Object)this.order);
        }
        return toString.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSort that = (SearchSort)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.order == that.order;
    }

    public int hashCode() {
        int result = this.order != null ? this.order.hashCode() : 0;
        result = 31 * result + this.field.hashCode();
        return result;
    }
}

