/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.project.Project;
import com.google.common.base.Predicate;

@ExperimentalApi
public final class IssueKey {
    private final String projectKey;
    private final long issueNumber;

    public IssueKey(String projectKey, long issueNumber) {
        this.projectKey = projectKey;
        this.issueNumber = issueNumber;
    }

    public IssueKey(Project project, long issueNumber) {
        this.projectKey = project.getKey();
        this.issueNumber = issueNumber;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public long getIssueNumber() {
        return this.issueNumber;
    }

    public String toString() {
        return this.projectKey + '-' + this.issueNumber;
    }

    public static IssueKey from(String key) {
        int dividerIndex = key.lastIndexOf("-");
        if (dividerIndex == -1) {
            throw new IllegalArgumentException("Invalid Issue Key '" + key + "' - it must contain a dash.");
        }
        if (dividerIndex == 0) {
            throw new IllegalArgumentException("Invalid Issue Key '" + key + "' - it must contain at least one character in the project key part.");
        }
        long number = Long.parseLong(key.substring(dividerIndex + 1));
        return new IssueKey(key.substring(0, dividerIndex), number);
    }

    public static String format(Project project, long issueNumber) {
        return IssueKey.format(project.getKey(), issueNumber);
    }

    public static String format(String projectKey, long issueNumber) {
        return projectKey + '-' + issueNumber;
    }

    public static boolean isValidKey(String issueKey) {
        try {
            IssueKey.from(issueKey);
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    @ExperimentalApi
    public static class IsValidIssueKeyPredicate
    implements Predicate<String> {
        public boolean apply(String issueKey) {
            return IssueKey.isValidKey(issueKey);
        }
    }
}

