/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import java.util.Collection;

public class UserFitsNavigatorHelper {
    private final UserSearchService userSearchService;

    public UserFitsNavigatorHelper(UserSearchService userSearchService) {
        this.userSearchService = userSearchService;
    }

    public String checkUser(String name) {
        String user = this.findUserName(name);
        if (user != null) {
            return user;
        }
        if (this.userExistsByFullNameOrEmail(name)) {
            return null;
        }
        return name;
    }

    String findUserName(String name) {
        ApplicationUser user = UserUtils.getUser(name.toLowerCase());
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    boolean userExistsByFullNameOrEmail(String name) {
        Collection<ApplicationUser> users = UserUtils.getAllUsers();
        for (ApplicationUser u : users) {
            String fullName = u.getDisplayName();
            String email = u.getEmailAddress();
            if (fullName != null && fullName.equalsIgnoreCase(name)) {
                return true;
            }
            if (email == null || !email.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

