/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

@ExperimentalApi
@PublicApi
public class RequestCachingConditionHelper {
    public static boolean cacheConditionResultInRequest(@Nonnull String cacheKey, @Nonnull Supplier<Boolean> supplier) {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request == null) {
            return (Boolean)supplier.get();
        }
        Object cachedConditionResult = request.getAttribute(cacheKey);
        if (cachedConditionResult == null || !(cachedConditionResult instanceof Boolean)) {
            try {
                boolean conditionResult = (Boolean)supplier.get();
                request.setAttribute(cacheKey, (Object)conditionResult);
                cachedConditionResult = conditionResult;
            }
            catch (Exception e) {
                return false;
            }
        }
        return (Boolean)cachedConditionResult;
    }
}

