/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.avatar.RemoteAvatar;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@ExperimentalApi
@Immutable
public class RemoteUser {
    private final String username;
    private final String displayName;
    private final boolean active;
    private final RemoteAvatar avatar;

    public RemoteUser(String username, String displayName, boolean active, RemoteAvatar avatar) {
        this.username = username;
        this.displayName = displayName;
        this.active = active;
        this.avatar = avatar;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public boolean isActive() {
        return this.active;
    }

    public RemoteAvatar getAvatar() {
        return this.avatar;
    }

    public static RemoteUser from(JSONObject user) throws JSONException {
        return new RemoteUser(user.getString("name"), user.getString("displayName"), user.getBoolean("active"), RemoteAvatar.from(user.getJSONObject("avatarUrls")));
    }

    public static RemoteUser from(ApplicationUser user) {
        return new RemoteUser(user.getUsername(), user.getDisplayName(), user.isActive(), RemoteAvatar.from(user));
    }
}

